/*
 * Created on Feb 23, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype;

/**
 * The Visitor for the field data types
 * 
 * @author Vijay Silva
 */
public interface IUIFieldDataTypeVisitor {

	/**
	 * Visit a Boolean data type
	 * 
	 * @param datatype The data type to visit
	 */
	public void visit(BooleanDataType datatype);

	/**
	 * Visit a Integer data type
	 * 
	 * @param datatype The data type to visit
	 */
	public void visit(IntegerDataType datatype);

	/**
	 * Visit a Float data type
	 * 
	 * @param datatype The data type to visit
	 */
	public void visit(FloatDataType datatype);

	/**
	 * Visit a Date data type
	 * 
	 * @param datatype The data type to visit
	 */
	public void visit(DateDataType datatype);

	/**
	 * Visit a Time data type
	 * 
	 * @param datatype The data type to visit
	 */
	public void visit(TimeDataType datatype);

	/**
	 * Visit a String data type
	 * 
	 * @param datatype The data type to visit
	 */
	public void visit(StringDataType datatype);
}
