/*
 * Created on Feb 23, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype;

/**
 * UI Model class representing the 'time' data type for the field value.
 * 
 * @author Vijay Silva
 */
public class TimeDataType extends UIFieldDataType {

	/** The name of the data type */
	public static final String NAME = "time";

	/**
	 * The boolean data type for UIField values
	 */
	public TimeDataType() {
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return NAME;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDisplayName() {
		return (NAMES != null) ? NAMES.timeName() : getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldDataTypeVisitor visitor) {
		visitor.visit(this);
	}

}
