/*
 * Created on Feb 20, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * UI Model class that represents the data type that a field value must obey.
 * 
 * @author Vijay Silva
 */
public abstract class UIFieldDataType implements IsSerializable  {

	/** The constants used for the data type display names */
	protected static final DataTypeNames NAMES = getDataTypeNames();

	/*
	 * Load the data type names only for client-side code
	 */
	private static final DataTypeNames getDataTypeNames() {
		DataTypeNames names = null;
		if (GWT.isClient()) {
			names = GWT.create(DataTypeNames.class);
		}
		return names;
	}

	/**
	 * Constructor
	 */
	public UIFieldDataType() {
	}

	/**
	 * Returns the name of the data type used by the back end (asset)
	 */
	public abstract String getName();

	/**
	 * Returns the display name to use for the data type
	 */
	public abstract String getDisplayName();

	/**
	 * Allows the data type to support the visitor pattern
	 * 
	 * @param visitor The visitor
	 */
	public abstract void accept(IUIFieldDataTypeVisitor visitor);
	
}
