/*
 * Created on Feb 23, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype;

import java.util.HashMap;
import java.util.Map;

/**
 * Data Type provider that provides all the data types supported for a UI Field value.
 * 
 * @author Vijay Silva
 */
public class UIFieldDataTypeProvider {

	/**
	 * Constructor
	 */
	public UIFieldDataTypeProvider() {
	}

	/**
	 * Creates all allowed data types (sorted by display name)
	 * 
	 * @return The list of all allowed data types
	 */
	public Map<String, UIFieldDataType> getAll() {
		Map<String, UIFieldDataType> dataTypes = new HashMap<String, UIFieldDataType>();
		dataTypes.put(BooleanDataType.NAME, new BooleanDataType());
		dataTypes.put(IntegerDataType.NAME, new IntegerDataType());
		dataTypes.put(FloatDataType.NAME, new FloatDataType());
		dataTypes.put(DateDataType.NAME, new DateDataType());
		dataTypes.put(TimeDataType.NAME, new TimeDataType());
		dataTypes.put(StringDataType.NAME, new StringDataType());
		return dataTypes;
	}
}
