package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.BooleanDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.DateDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.FloatDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.IntegerDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.StringDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.TimeDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.google.gwt.user.client.rpc.IsSerializable;


/**
 * A list of valid operators for a search parameter *
 * 
 */
public class BaseOperator implements IsSerializable{

    private static HashMap<String, BaseOperator> valueLookup = new HashMap<String, BaseOperator>();
    public static final BaseOperator EQUAL = new BaseOperator("equal", ParamType.VALUE, true, false, true);
    public static final BaseOperator LESSTHAN = new BaseOperator("lessThan", ParamType.VALUE, true);
    public static final BaseOperator LESSTHANEQUAL = new 	BaseOperator("lessThanEqual", ParamType.VALUE, true);
    public static final BaseOperator GREATERTHAN =  new BaseOperator("greaterThan", ParamType.VALUE, true);
    public static final BaseOperator GREATERTHANEQUAL =  new BaseOperator("greaterThanEqual", ParamType.VALUE, true);
    public static final BaseOperator IN =  new BaseOperator("in", ParamType.LIST, true, false, false);
    public static final BaseOperator ISEMPTY =  new BaseOperator("isEmpty", ParamType.NONE, false);
    public static final BaseOperator STARTSWITH =  new BaseOperator("startsWith", ParamType.VALUE, true);
    public static final BaseOperator ENDSWITH =  new BaseOperator("endsWith", ParamType.VALUE, true);
    public static final BaseOperator CONTAINS =  new BaseOperator("contains", ParamType.VALUE, true);
    public static final BaseOperator LENGTHEQUALS =  new BaseOperator("lengthEquals", ParamType.VALUE, false);
    public static final BaseOperator LENGTHLESSTHAN=  new BaseOperator("lengthLessThan", ParamType.VALUE, false);
    public static final BaseOperator LENGTHGREATERTHAN =  new BaseOperator("lengthGreaterThan", ParamType.VALUE, false);
    public static final BaseOperator LESSTHANTODAY = new BaseOperator("lessThanToday", ParamType.VALUE, false);
    public static final BaseOperator EQUALTOTODAY = new BaseOperator("equalToToday", ParamType.NONE, false);
    public static final BaseOperator GREATERTHANTODAY = new BaseOperator("greaterThanToday", ParamType.VALUE, false);
    public static final BaseOperator REGEX =  new BaseOperator("regex", ParamType.VALUE, false);
    public static final BaseOperator CONTAINSUNPARSABLE =  new BaseOperator("containsUnparsable", ParamType.NONE, false);
    public static final BaseOperator FIELDINVALID = new BaseOperator("fieldInvalid", ParamType.NONE, false);
    public static final BaseOperator TIER1EQUALS = new BaseOperator("tier1Equals", ParamType.VALUE, true);
    public static final BaseOperator TIER2EQUALS = new BaseOperator("tier2Equals", ParamType.VALUE, true);
    public static final BaseOperator TIER3EQUALS = new BaseOperator("tier3Equals", ParamType.VALUE, true);
    public static final BaseOperator TIER4EQUALS = new BaseOperator("tier4Equals", ParamType.VALUE, true);
    public static final BaseOperator MISSINGCONTENT = new BaseOperator("missingContent", ParamType.NONE, false);
    public static final BaseOperator EVALCHILDFIELDS = new BaseOperator("evalChildFields", ParamType.COMPLEX, false);
    public static final BaseOperator NUMINSTANCESEQUAL = new BaseOperator("numInstancesEqual", ParamType.VALUE, false, true, false);
    public static final BaseOperator NUMINSTANCESGREATERTHAN = new BaseOperator("numInstancesGreaterThan", ParamType.VALUE, false, true, false);
    public static final BaseOperator NUMINSTANCESLESSTHAN = new BaseOperator("numInstancesLessThan", ParamType.VALUE, false, true, false);
    public static final BaseOperator BETWEEN = new BaseOperator("between", ParamType.RANGE, false);
    public static final BaseOperator TIMEEQUALS = new BaseOperator("timeEquals", ParamType.VALUE, false);
    public static final BaseOperator TIMELESSTHAN = new BaseOperator("timeLessThan", ParamType.VALUE, false);
    public static final BaseOperator TIMEGREATERTHAN = new BaseOperator("timeGreaterThan", ParamType.VALUE, false);
    public static final BaseOperator TOTALLENGTHEQUALS =  new BaseOperator("totalLengthEquals", ParamType.VALUE, false, true, false);
    public static final BaseOperator TOTALLENGTHLESSTHAN=  new BaseOperator("totalLengthLessThan", ParamType.VALUE, false, true, false);
    public static final BaseOperator TOTALLENGTHGREATERTHAN =  new BaseOperator("totalLengthGreaterThan", ParamType.VALUE, false, true, false);

    public static final String CATEGORY_XPATH = "/Fields/Categories/Category/Text";

    private static final String RATING = "/Fields/Rating/RatingValues/RatingValue";
    private static final String RATING_VALUE = "/Fields/Rating/RatingValues/RatingValue/Value";
    private static final String RATING_SYSTEM = "/Fields/Rating/RatingValues/RatingValue/System";
    private static final String GENRE = "/Fields/Genres/Genre/Value";
    private static final String PRODUCT = "/Fields/ProductInfo/Name";
    private static final String STUDIO = "/Fields/CreationInfo/Studio";
    private static final String STUDIO_DISPLAY = "/Fields/CreationInfo/Studio/DisplayName";
    private static final String STUDIO_NAME = "/Fields/CreationInfo/Studio/Name";
    private static final String STUDIO_CODE = "/Fields/CreationInfo/Studio/Code";

    private String key;
    private ParamType searchParamType;
    private boolean useSuggestedValues;
    private boolean multiFieldOperator;
    private boolean allowRhsField;

    public BaseOperator() {

    }

    protected BaseOperator(String key, ParamType paramType, boolean allowRhsField) {
        this(key, paramType, false, false, allowRhsField);
    }

    protected BaseOperator(String key, ParamType paramType, boolean useSuggestedValues, boolean isMultiField, boolean allowRhsField) {
        this.key = key;
        searchParamType = paramType;
        this.useSuggestedValues = useSuggestedValues;
        multiFieldOperator = isMultiField;
        valueLookup.put(key.toUpperCase(), this);
        this.allowRhsField = allowRhsField;
    }

    @Override
    public String toString() {
        return key;
    }

    public ParamType getParamType() {
        return searchParamType;
    }

    public boolean hasRightSide() {
        return searchParamType == ParamType.VALUE
                || searchParamType == ParamType.LIST
                || searchParamType == ParamType.RANGE;
    }

    public boolean allowRhsField() {
        return allowRhsField;
    }

    public static BaseOperator valueOf(String key) {
        return valueLookup.get(key);
    }

    public static Collection<BaseOperator> values() {
        return valueLookup.values();
    }

    public static BaseOperator lookup(String operator) {
        Collection<BaseOperator> values = values();
        for(BaseOperator val : values) {
            if(val.key.equalsIgnoreCase(operator)) {
                return val;
            }
        }
        return null;
    }

    public boolean multiValued() {
        //TODO refactor so it handles ranges better
        return searchParamType == ParamType.LIST;
    }

    /**
     * returns the operators that are valid for this dataType
     * @param xpath
     * @param dataType the Data Type
     * @param onlySuggestedValues
     * @return
     */
    public List<BaseOperator> getOperators(IFieldTreeObject obj) {
        UIFieldDataType dataType = obj.getDataType();
        if (dataType == null) {
            return this.complexDataType(obj);
        }
        if (dataType instanceof StringDataType) {
            return stringDataType(obj);
        }
        if (dataType instanceof IntegerDataType) {
            return integerDataType(obj);
        }
        if (dataType instanceof FloatDataType) {
            return floatDataType(obj);
        }
        if (dataType instanceof DateDataType) {
            return dateDataType(obj);
        }
        if (dataType instanceof  TimeDataType) {
            return timeDataType(obj);
        }
        if (dataType instanceof BooleanDataType) {
            return booleanDataType(obj);
        }
        //if we don't have operators for that data type return an empty list
        return new SoArrayList(obj);
    }

    protected List<BaseOperator> complexDataType(IFieldTreeObject obj) {
        List<BaseOperator> result = new SoArrayList(obj);
        result.add(BaseOperator.ISEMPTY);
        result.add(BaseOperator.CONTAINSUNPARSABLE);
        return result;
    }

    protected List<BaseOperator> stringDataType(IFieldTreeObject obj) {
        List<BaseOperator> result = new SoArrayList(obj);
        result.add(BaseOperator.CONTAINS);
        result.add(BaseOperator.EQUAL);
        result.add(BaseOperator.IN);
        result.add(BaseOperator.STARTSWITH);
        result.add(BaseOperator.ENDSWITH);
        result.add(BaseOperator.ISEMPTY);
        return result;
    }

    protected List<BaseOperator> integerDataType(IFieldTreeObject obj) {
        List<BaseOperator> result = new SoArrayList(obj);
        result.add(BaseOperator.EQUAL);
        result.add(BaseOperator.LESSTHAN);
        result.add(BaseOperator.LESSTHANEQUAL);
        result.add(BaseOperator.GREATERTHAN);
        result.add(BaseOperator.GREATERTHANEQUAL);
        result.add(BaseOperator.IN);
        /**
         * Keep since BaseOperator.java don't comment them under com.tandbergtv.cms.portal.ui.title.client.model.search
         * if(!obj.getField().equals(PMMFieldProvider.TITLE_ID)) { result.add(BaseOperator.ISEMPTY);
         * result.add(BaseOperator.CONTAINSUNPARSABLE); }
         */
        return result;
    }

    protected List<BaseOperator> floatDataType(IFieldTreeObject obj) {
        List<BaseOperator> result = new SoArrayList(obj);
        result.add(BaseOperator.EQUAL);
        result.add(BaseOperator.LESSTHAN);
        result.add(BaseOperator.LESSTHANEQUAL);
        result.add(BaseOperator.GREATERTHAN);
        result.add(BaseOperator.GREATERTHANEQUAL);
        result.add(BaseOperator.IN);
        result.add(BaseOperator.ISEMPTY);
        result.add(BaseOperator.CONTAINSUNPARSABLE);
        return result;
    }

    protected List<BaseOperator> booleanDataType(IFieldTreeObject obj) {
        List<BaseOperator> result = new SoArrayList(obj);
        result.add(BaseOperator.EQUAL);
        result.add(BaseOperator.ISEMPTY);
        result.add(BaseOperator.CONTAINSUNPARSABLE);
        return result;
    }

    protected List<BaseOperator> dateDataType(IFieldTreeObject obj) {
        List<BaseOperator> result = new SoArrayList(obj);
        result.add(BaseOperator.EQUAL);
        result.add(BaseOperator.LESSTHAN);
        result.add(BaseOperator.LESSTHANEQUAL);
        result.add(BaseOperator.LESSTHANTODAY);
        result.add(BaseOperator.EQUALTOTODAY);
        result.add(BaseOperator.GREATERTHAN);
        result.add(BaseOperator.GREATERTHANEQUAL);
        result.add(BaseOperator.GREATERTHANTODAY);
        result.add(BaseOperator.ISEMPTY);
        result.add(BaseOperator.CONTAINSUNPARSABLE);
        return result;
    }

    protected List<BaseOperator> timeDataType(IFieldTreeObject obj) {
        List<BaseOperator> result = new SoArrayList(obj);
        result.add(BaseOperator.EQUAL);
        result.add(BaseOperator.LESSTHAN);
        result.add(BaseOperator.LESSTHANEQUAL);
        result.add(BaseOperator.GREATERTHAN);
        result.add(BaseOperator.GREATERTHANEQUAL);
        result.add(BaseOperator.ISEMPTY);
        result.add(BaseOperator.CONTAINSUNPARSABLE);
        return result;
    }

    protected void addCategoryOperators(String xpath, List<BaseOperator> list) {
        if(xpath.equals(CATEGORY_XPATH)) {
            list.add(BaseOperator.TIER1EQUALS);
            list.add(BaseOperator.TIER2EQUALS);
            list.add(BaseOperator.TIER3EQUALS);
            list.add(BaseOperator.TIER4EQUALS);
        }
    }

    protected void addFieldInvalidOperator(String xpath, List<BaseOperator> list) {
        if(xpath.equals(CATEGORY_XPATH)
                || xpath.equals(RATING)
                || xpath.equals(RATING_VALUE)
                || xpath.equals(RATING_SYSTEM)
                || xpath.equals(GENRE)
                || xpath.equals(PRODUCT)
                || xpath.equals(STUDIO)
                || xpath.equals(STUDIO_DISPLAY)
                || xpath.equals(STUDIO_NAME)
                || xpath.equals(STUDIO_CODE)) {
            list.add(BaseOperator.FIELDINVALID);
        }
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + (key == null ? 0 : key.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if(o instanceof BaseOperator) {
            return ((BaseOperator) o).key.equals(this.key);
        }
        return false;
    }

    public boolean useSuggestedValues() {
        return useSuggestedValues;
    }

    public boolean isMultiFieldOperator() {
        return multiFieldOperator;
    }
}
