/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.google.gwt.user.client.rpc.IsSerializable;


/**
 * Main class that represents the Title Filter UI Model
 * 
 * @author vaibhav
 */
public class UITitleFilter implements IsSerializable {

    private IUITitleFilterNode rootNode;

    // paging info
    private UiPageInfo pageInfo;
    private boolean includeCount;

    // sorting info
    private UiSortInfo sortInfo;

    private UiCriteriaMode criteriaMode;

    public UITitleFilter() {
        super();
        this.sortInfo = new UiSortInfo();
        this.pageInfo = new UiPageInfo();
        criteriaMode = UiCriteriaMode.EPISODE;
    }

    public UITitleFilter(IUITitleFilterNode rootNode,
            String sortColumnName, String sortColumnSection, UISortOrder sortOrder,
            UIFieldType sortFieldType, UiCriteriaMode criteriaMode)  {
        super();
        this.sortInfo = new UiSortInfo(sortColumnName, sortColumnSection, sortOrder, sortFieldType);
        this.pageInfo = new UiPageInfo();
        this.rootNode = rootNode;
        this.setCriteriaMode(criteriaMode);
    }

    /**
     * @return the rootNode
     */
    public IUITitleFilterNode getRootNode() {
        return rootNode;
    }

    /**
     * @param rootNode
     *            the rootNode to set
     */
    public void setRootNode(IUITitleFilterNode rootNode) {
        this.rootNode = rootNode;
    }

    public UiPageInfo getPageInfo() {
        return pageInfo;
    }

    public void setPageInfo(UiPageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public UiSortInfo getSortInfo() {
        return sortInfo;
    }

    public void setSortInfo(UiSortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    public boolean isCountIncluded() {
        return includeCount;
    }

    public void setIncludeCount(boolean includeCount) {
        this.includeCount = includeCount;
    }

    public UiCriteriaMode getCriteriaMode() {
        return criteriaMode;
    }

    public void setCriteriaMode(UiCriteriaMode criteriaMode) {
        this.criteriaMode = criteriaMode;
    }
}
