package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search;

public abstract class UITitleFilterConditionNode implements IUITitleFilterNode {
    // whether this is a PMM_Title field or an Asset Field
    private UIFieldType fieldTypeLhs;
    /*
     * For metadata fields, this property defines the item type (e.g. MOVIE,
     * POSTER...) to filter by
     */
    private String sectionTypeLhs;

    /* internal name of the field */
    private String fieldLhs;

    /* data type of the field */
    private String dataType;

    /* search operator for this field */
    private BaseOperator searchOperator;

    /* value, list or range type */
    private ParamType paramType;



    private boolean ignoreCase;

    /* whether this has a not. As in !(x == y) */
    private boolean not = false;

    public UITitleFilterConditionNode() {
        super();
    }

    public UITitleFilterConditionNode(String fieldLhs, String sectionTypeLhs,
            UIFieldType fieldTypeLhs, BaseOperator operator,
            ParamType paramType, boolean ignoreCase, boolean not,
            String dataType) {
        this.fieldLhs = fieldLhs;
        this.searchOperator = operator;
        this.sectionTypeLhs = sectionTypeLhs;
        this.fieldTypeLhs = fieldTypeLhs;
        this.paramType = paramType;
        this.ignoreCase = ignoreCase;
        this.not = not;
        this.dataType = dataType;
    }

    public String getField() {
        return fieldLhs;
    }

    public void setField(String field) {
        this.fieldLhs = field;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public BaseOperator getSearchOperator() {
        return searchOperator;
    }

    public String getSearchOperatorString() {
        return searchOperator.toString();
    }

    public void setSearchOperator(BaseOperator searchOperator) {
        this.searchOperator = searchOperator;
    }

    public void setSearchOperator(String searchOperator) {
        this.searchOperator = BaseOperator
                .valueOf(searchOperator.toUpperCase());
    }

    public ParamType getParamType() {
        return paramType;
    }

    public String getParamTypeString() {
        return paramType.toString();
    }

    public void setParamType(String paramType) {
        this.paramType = ParamType.valueOf(paramType.toUpperCase());
    }

    public void setParamType(ParamType paramType) {
        this.paramType = paramType;
    }

    /**
     * @return the sectionType
     */
    public String getSectionType() {
        return sectionTypeLhs;
    }

    /**
     * @param sectionType
     *            the sectionType to set
     */
    public void setSectionType(String sectionType) {
        this.sectionTypeLhs = sectionType;
    }

    public boolean isIgnoreCase() {
        return ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    /**
     * Sets the value not operator for this value node.
     * 
     * @param not
     */
    public void setNot(boolean not) {
        this.not = not;
    }

    /**
     * Gets the value of the not operator for this value node.
     * 
     * @return
     */
    public boolean isNot() {
        return not;
    }

    public void setFieldType(UIFieldType fieldType) {
        this.fieldTypeLhs = fieldType;
    }

    public UIFieldType getFieldType() {
        return fieldTypeLhs;
    }

    public abstract RhsType getRhsType();

}
