package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search;

import java.util.List;

/**
 * 
 * @author dweiner
 *
 */
public class UITitleSearch extends UITitleSearchBase {
	private boolean share;
	private UITitleFilter titleFilter;

	public UITitleSearch() {
		super();
	}

	public UITitleSearch(int id, String userName, String name,
			UITitleFilter titleFilter, boolean share, 
			List<UiColumn> displayColumns) {
		super(id, name, userName, displayColumns);
		this.titleFilter = titleFilter;
		this.share = share;
	}
	
	public UITitleSearch(int id, String userName, String name,
			UITitleFilter titleFilter, boolean share) {
		super(id, name, userName);
		this.titleFilter = titleFilter;
		this.share = share;
	}
	
	public UITitleSearch(String userName, String name,
			UITitleFilter titleFilter, boolean share, 
			List<UiColumn> displayColumns) {
		//-1 means it's new
		this(-1,userName,name,titleFilter,share, displayColumns);
	}
	
	public UITitleSearch(String userName, String name,
			UITitleFilter titleFilter, boolean share) {
		//-1 means it's new
		this(-1,userName,name,titleFilter,share);
	}

	/**
	 * Returns true if this search is to be shared with users other than the owner.
	 * @return
	 */
	public boolean isShare() {
		return share;
	}

	/**
	 * Set whether this search is to be shared with users other than the owner.
	 * @return
	 */
	public void setShare(boolean share) {
		this.share = share;
	}

	/**
	 * Sets the title filter.
	 * @param titleFilter
	 */
	public void setTitleFilter(UITitleFilter titleFilter) {
		this.titleFilter = titleFilter;
	}

	/**
	 * Gets the title filter.
	 * @return
	 */
	public UITitleFilter getTitleFilter() {
		return titleFilter;
	}

}
