package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * This is the base DTO for saved Title Searches. IT is a shallow copy of the
 * search and only contains what is necessary to list the searches.
 * 
 * @author dweiner
 * 
 */
public class UITitleSearchBase implements IsSerializable {
	private int titleSearchId;
	private String name;
	private String userName;
	private List<UiColumn> displayColumns;
	
	public UITitleSearchBase() {
		super();
		displayColumns = new ArrayList<UiColumn>();
	}

	public UITitleSearchBase(int titleSearchId, String name, String userName) {
		super();
		this.titleSearchId = titleSearchId;
		this.name = name;
		this.setUserName(userName);
		displayColumns = new ArrayList<UiColumn>();
	}
 
	public UITitleSearchBase(int titleSearchId, String name, String userName,
			List<UiColumn> displayColumns) {
		super();
		this.titleSearchId = titleSearchId;
		this.name = name;
		this.setUserName(userName);
		this.displayColumns = displayColumns;
	}

	/**
	 * Sets the identifier for this search.
	 * @param titleSearchId
	 */
	public void setTitleSearchId(int titleSearchId) {
		this.titleSearchId = titleSearchId;
	}

	/**
	 * Returns the identifier for this search.
	 * @return
	 */
	public int getTitleSearchId() {
		return titleSearchId;
	}

	/**
	 * Sets the name of this search.
	 * 
	 * @param name
	 *            The name of this search.
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Returns the name of this search.
	 * 
	 * @return The name of this search.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the user name of the owner of this search.
	 * 
	 * @param userName
	 *            The owner of this search.
	 */
	public void setUserName(String userName) {
		this.userName = userName;
	}

	/**
	 * Returns the user name of the owner of this search.
	 * 
	 * @return The owner of this search.
	 */
	public String getUserName() {
		return userName;
	}

	public List<UiColumn> getDisplayColumns() {
		return displayColumns;
	}

	public void setDisplayColumns(List<UiColumn> displayColumns) {
		this.displayColumns = displayColumns;
	}	
}
