package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UiSortInfo implements IsSerializable {

	// ttvxpath in case of metadata or title property
	private String sortColumnName;
	// asset type in case of metadata
	private String sortColumnSection;
	// asc or desc sort order
	private UISortOrder sortOrder;
	// is the sort field an asset metadata
	private UIFieldType sortFieldType;

	public UiSortInfo() {
		
	}
	
	public UiSortInfo(String sortColumnName, String sortColumnSection,
			UISortOrder sortOrder, UIFieldType sortFieldType) {
		super();
		this.sortColumnName = sortColumnName;
		this.sortColumnSection = sortColumnSection;
		this.sortOrder = sortOrder;
		this.setSortFieldType(sortFieldType);
	}
	
	public boolean isEmpty() {
		return sortColumnName == null || sortColumnName.isEmpty()
				|| sortOrder == null;
	}

	public String getSortColumnName() {
		return sortColumnName;
	}

	public void setSortColumnName(String sortColumnName) {
		this.sortColumnName = sortColumnName;
	}

	public String getSortColumnSection() {
		return sortColumnSection;
	}

	public void setSortColumnSection(String sortColumnSection) {
		this.sortColumnSection = sortColumnSection;
	}

	public UISortOrder getSortOrder() {
		return sortOrder;
	}

	public void setSortOrder(UISortOrder sortOrder) {
		this.sortOrder = sortOrder;
	}

	public void setSortFieldType(UIFieldType sortFieldType) {
		this.sortFieldType = sortFieldType;
	}

	public UIFieldType getSortFieldType() {
		return sortFieldType;
	}

}
