/*
 * Created on Feb 20, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * UI Model class representing a specification
 * 
 * @author Vijay Silva
 */
public class UIAssetSpecification implements IsSerializable 
{
	private String name;
	private String displayName;
	private List<UIAssetDefinition> definitions = new ArrayList<UIAssetDefinition>();

	private long contentClassId;
	private int contentClassTypeId;
	private String contentClassName;
	private long partnerId;
	private String providerId;
	
	/**
	 * Constructor
	 */
	public UIAssetSpecification() {
	}

	/**
	 * Constructs a new asset specification with the given specification name
	 * 
	 * @param name The specification name
	 */
	public UIAssetSpecification(String name) {
		this.name = name;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	public String getProviderId()
	{
		return providerId;
	}
	
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the display name
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * @param displayName the display name to set
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	
	
	public String getContentClassName() {
		return contentClassName;
	}

	public void setContentClassName(String contentClassName) {
		this.contentClassName = contentClassName;
	}

	
	public long getContentClassId() {
		return contentClassId;
	}

	public void setContentClassId(long contentClassId) {
		this.contentClassId = contentClassId;
	}

	public long getPartnerId() {
		return partnerId;
	}

	public void setPartnerId(long partnerId) {
		this.partnerId = partnerId;
	}

	public void setProviderId(String providerId) {
		this.providerId = providerId;
	}

	public int getContentClassTypeId() {
		return contentClassTypeId;
	}

	public void setContentClassTypeId(int contentClassTypeId) {
		this.contentClassTypeId = contentClassTypeId;
	}

	/**
	 * @return the definitions
	 */
	public List<UIAssetDefinition> getAssetDefinitions() {
		return definitions;
	}

	/**
	 * @param definitions the definitions to set
	 */
	public void setAssetDefinitions(List<UIAssetDefinition> definitions) {
		this.definitions = (definitions != null) ? definitions : new ArrayList<UIAssetDefinition>();
	}

	/**
	 * Get an child definition with matching asset type
	 * 
	 * @param assetType The asset type
	 * @return the asset definition
	 */
	public UIAssetDefinition getAssetDefinition(String assetType) {
		UIAssetDefinition definition = null;

		for (UIAssetDefinition child : this.definitions) {
			if (assetType.equals(child.getAssetType())) {
				definition = child;
				break;
			}
		}

		return definition;
	}

	/**
	 * Add an asset definition to the list of supported definitions
	 * 
	 * @param assetDefinition The asset definition
	 */
	public void addAssetDefinition(UIAssetDefinition assetDefinition) {
		if (assetDefinition != null) {
			assetDefinition.setSpecification(this);
			definitions.add(assetDefinition);
		}
	}
	

	/**
	 * Find first asset in a group definition. 
	 * Do search recursively in children, depth first.
	 * @param assetType
	 * @return
	 */
	public UIAssetDefinition findFirstAssetDefinition(String assetType) {
		// Validation
		if(assetType == null) {
			return null;
		}
		
		// Iterate over root asset definitions
		for(UIAssetDefinition def : this.definitions) {
			// Roor definition is the one we are looking for
			if(assetType.equals(def.getAssetType())) {
				return def;
			}
			// This is a group. Search it recursively, depth first.
			if(def instanceof UIGroupAssetDefinition) {
				UIGroupAssetDefinition groupDef = (UIGroupAssetDefinition)def;
				UIAssetDefinition childDef = findFirstAssetDefinition(groupDef, assetType);
				if(childDef != null) {
					return childDef;
				}
			}
		}
		
		return null;
	}
	
	/**
	 * Find first asset in a group definition. 
	 * Do search recursively in children, depth first.
	 * @param groupDef
	 * @param assetType
	 * @return
	 */
	private UIAssetDefinition findFirstAssetDefinition(UIGroupAssetDefinition groupDef, String assetType) {
		// Validation
		if(groupDef == null || assetType == null) {
			return null;
		}
		List<UIAssetDefinition> defs = groupDef.getChildren();
		
		// Iterate over asset definitions
		for(UIAssetDefinition def : defs) {
			// This is the definition we are looking for
			if(assetType.equals(def.getAssetType())) {
				return def;
			}
			// This is a group. Search it recursively, depth first.
			if(def instanceof UIGroupAssetDefinition) {
				UIGroupAssetDefinition childGroupDef = (UIGroupAssetDefinition)def;
				UIAssetDefinition childDef = findFirstAssetDefinition(childGroupDef, assetType);
				if(childDef != null) {
					return childDef;
				}
			}
		}
		
		return null;
	}

	/**
	 * Gets first UI asset definition.
	 * @return first UI asset definition or NULL if there are no UI asset definitions
	 */
	public UIAssetDefinition getFirstRootDefinition() {
		if(definitions != null && !definitions.isEmpty()) {
			return definitions.get(0);
		}
		
		return null;
	}
}
