/*
 * Created on Feb 24, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * UI Model representing an Asset Specification list item that contains the basic display and key
 * information for a specification.
 * 
 * @author Vijay Silva
 */
public class UIAssetSpecificationListItem implements IsSerializable {

	/* Properties */
	private String name;
	private String displayName;

	/**
	 * Constructor
	 */
	public UIAssetSpecificationListItem() {
	}

	/**
	 * Constructs a specification list item
	 * 
	 * @param name The specification name
	 * @param displayName The specification display name
	 */
	public UIAssetSpecificationListItem(String name, String displayName) {
		setName(name);
		setDisplayName(displayName);
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the display name
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * @param displayName the display name to set
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}
}
