/*
 * Created on Feb 20, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification;

/**
 * UI Model class that represents the definition of an 'Item' asset for a specification.
 * 
 * @author Vijay Silva
 */
public class UIItemAssetDefinition extends UIAssetDefinition {

	/* Properties */
	private String assetType;

	/**
	 * Constructor
	 */
	public UIItemAssetDefinition() {
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getAssetType() {
		return assetType;
	}

	/**
	 * @param assetType the asset type to set
	 */
	public void setAssetType(String assetType) {
		this.assetType = assetType;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIAssetDefinitionVisitor visitor) {
		visitor.visit(this);
	}
}
