/*
 * Created on Feb 19, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;


/**
 * UI Model object that represents an asset field definition that contains a value.
 * 
 * @author Vijay Silva
 */
public abstract class UISimpleFieldDefinition extends UIFieldDefinition 
{
	private boolean attribute;
	private boolean batch;
	private boolean autoFillable;
	private boolean anyValueAllowed = true;

	private List<UIValueOption> suggestedValues;
	
	// Values from content class 
	private String defaultValue;
	private boolean locked;
	private boolean required;

	/** The field name of the simple field when wrapped in complex field */
	public static final String WRAPPED_FIELD_NAME = null;

	/**
	 * Default Constructor
	 */
	public UISimpleFieldDefinition() {
	}

	/**
	 * @return the data type
	 */
	public abstract UIFieldDataType getDatatype();

	/**
	 * @return the attribute
	 */
	public boolean isAttribute() {
		return attribute;
	}

	/**
	 * @param attribute the attribute to set
	 */
	public void setAttribute(boolean attribute) {
		this.attribute = attribute;
	}

	/**
	 * @return the batch
	 */
	@Override
	public boolean isBatch() {
		return batch;
	}

	/**
	 * @param batch the batch to set
	 */
	public void setBatch(boolean batch) {
		this.batch = batch;
	}

	/**
	 * @return the autoFillable
	 */
	public boolean isAutoFillable() {
		return autoFillable;
	}

	/**
	 * @param autoFillable the autoFillable to set
	 */
	public void setAutoFillable(boolean autoFillable) {
		this.autoFillable = autoFillable;
	}


	/**
	 * Get the list of suggested values
	 * 
	 * @return the suggestedValues
	 */
	public List<UIValueOption> getSuggestedValues() 
	{
		return this.suggestedValues;
	}

	/**
	 * Sets suggested values to be displayed in drop-down box
	 * @param suggestedValues
	 */
	public void setSuggestedValues(List<UIValueOption> suggestedValues) 
	{
		this.suggestedValues = suggestedValues;
	}
	
	/**
	 * Determine if any value is allowed or if only the suggested values can be used. If no
	 * suggested values are present, this field is ignored.
	 * 
	 * @return true if any value is allowed, false if only suggested values are allowed
	 */
	public boolean isAnyValueAllowed() {
		return anyValueAllowed;
	}

	/**
	 * @param anyValueAllowed false if only the suggested values are allowed, true otherwise
	 */
	public void setAnyValueAllowed(boolean anyValueAllowed) {
		this.anyValueAllowed = anyValueAllowed;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public boolean isLocked() {
		return locked;
	}

	public void setLocked(boolean locked) {
		this.locked = locked;
	}

	public boolean isRequired() {
		return required;
	}

	public void setRequired(boolean required) {
		this.required = required;
	}
	
}
