/*
 * Created on Jun 3, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.StringDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;

/**
 * Field definition for a simple field that contains a string value
 * 
 * @author Vijay Silva
 */
public class UIStringFieldDefinition extends UISimpleFieldDefinition {

	private UIFieldDataType datatype = new StringDataType();
	private boolean longForm = false;
	private boolean isPositionField = false;

	/**
	 * {@inheritDoc}
	 */
	@Override
	public UIFieldDataType getDatatype() {
		return this.datatype;
	}

	/**
	 * @return the longForm
	 */
	public boolean isLongForm() {
		return longForm;
	}

	/**
	 * @param longForm the longForm to set
	 */
	public void setLongForm(boolean longForm) {
		this.longForm = longForm;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldDefinitionVisitor visitor) {
		visitor.visit(this);
	}

	public boolean isPositionField() {
		return isPositionField;
	}

	public void setPositionField(boolean isPositionField) {
		this.isPositionField = isPositionField;
	}
}
