/*
 * Created on Jun 3, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.TimeDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;

/**
 * Field definition for a simple field that contains a time value
 * 
 * @author Vijay Silva
 */
public class UITimeFieldDefinition extends UISimpleFieldDefinition 
{
	private UIFieldDataType datatype = new TimeDataType();
	private String displayFormat;

	/** The pattern that the value must obey for this field */
	public static final String TIME_PATTERN = "HH:mm:ss";

	/**
	 * {@inheritDoc}
	 */
	@Override
	public UIFieldDataType getDatatype() {
		return this.datatype;
	}

	/**
	 * @return the display format to use when displaying a value
	 */
	public String getDisplayFormat() {
		return displayFormat;
	}

	/**
	 * @param displayFormat the display format to set
	 */
	public void setDisplayFormat(String displayFormat) {
		this.displayFormat = displayFormat;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldDefinitionVisitor visitor) {
		visitor.visit(this);
	}
}
