package com.ericsson.cms.epgmgmt.client.events;

import com.ericsson.cms.epgmgmt.client.rules.extend.IEPGNormalizationRuleForm;
import com.google.gwt.event.shared.GwtEvent;

public class RuleReorderEvent extends GwtEvent<RuleReorderHandler> {
	public static final Type<RuleReorderHandler> TYPE = new Type<RuleReorderHandler>();
	private IEPGNormalizationRuleForm rule;
	private int newIndex;

	public RuleReorderEvent(IEPGNormalizationRuleForm rule, int newIndex) {
		this.setRule(rule);
		this.setNewIndex(newIndex);
	}

	@Override
	protected void dispatch(RuleReorderHandler handler) {
		handler.reorder(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<RuleReorderHandler> getAssociatedType() {
		return TYPE;
	}

	public void setRule(IEPGNormalizationRuleForm rule) {
		this.rule = rule;
	}

	public IEPGNormalizationRuleForm getRule() {
		return rule;
	}

	public void setNewIndex(int newIndex) {
		this.newIndex = newIndex;
	}

	public int getNewIndex() {
		return newIndex;
	}
}
