package com.ericsson.cms.epgmgmt.client.model;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * We can't extend the JobFilter directly, since the source code of JobFilter don't
 * be included in UI module.
 * @author toy
 *
 */
public class ExecutionLogFilter implements IsSerializable  {
    private Long taskId;
    private Long partnerId;
    private String partnerType;
    private long startDate = 0L;
    private long endDate = 0L;
    private String status;

    private int pageNumber;
    private int pageSize;

    private String sortProperty;
    private boolean isAscending;


    public Long getTaskId() {
        return taskId;
    }
    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }
    public Long getPartnerId() {
        return partnerId;
    }
    public void setPartnerId(Long partnerId) {
        this.partnerId = partnerId;
    }
    public String getPartnerType() {
        return partnerType;
    }
    public void setPartnerType(String partnerType) {
        this.partnerType = partnerType;
    }
    public String getStatus() {
        return status;
    }
    public void setStatus(String status) {
        this.status = status;
    }
    public long getStartDate() {
        return startDate;
    }
    public long getEndDate() {
        return endDate;
    }




    public void setStartDate(long time) {
        this.startDate = time;
    }
    public void setEndDate(long time) {
        this.endDate = time;
    }

    public int getPageNumber() {
        return pageNumber;
    }
    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }
    public int getPageSize() {
        return pageSize;
    }
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
    public String getSortProperty() {
        return sortProperty;
    }
    public void setSortProperty(String sortProperty, boolean isAscending) {
        this.sortProperty = sortProperty;
        this.isAscending = isAscending;
    }
    public boolean isAscending() {
        return isAscending;
    }

    public void setPageInfo(int pageNumber, int length, String sortColumnName, boolean ascending) {
        setPageNumber(pageNumber);
        setPageSize(length);
        setSortProperty(sortColumnName, ascending);
    }

}
