package com.ericsson.cms.epgmgmt.client.model;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.enumeration.PartnerType;
import com.google.gwt.core.client.GWT;

public final class PartnerConstantUtils {
    private final static EPGComponentConstants CONSTANTS = GWT.create(EPGComponentConstants.class);

    public static String getPartnerType(UIPartner partner) {
        return getPartnerType(partner.getPartnerType());
    }

    public static String getPartnerType(PartnerType partnerType) {
        return partnerType == PartnerType.Provider ? CONSTANTS.provider() : CONSTANTS.publisher();
    }
    
    public static String getPartnerActionType(UIPartner partner) {
        return partner.getPartnerType() == PartnerType.Provider ? CONSTANTS.onIngest() : CONSTANTS.onExport();
    }
    
    
}
