package com.ericsson.cms.epgmgmt.client.model;

import java.util.ArrayList;
import java.util.Collection;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Result object which contains the Program Guide(could be a subset) and the total number of Program Guides in the
 * system.
 * 
 * @author Gunnar Maluf
 * 
 */
public class ProgramGuideSearchResult implements IsSerializable {

    private Collection<UiProgramGuideResult> uiProgramGuideList;
    private int totalCount;
    
    public ProgramGuideSearchResult() {
    }

    public ProgramGuideSearchResult( Collection<UiProgramGuideResult> lists, int totalCount ) {
        this.uiProgramGuideList = lists;
        if ( this.uiProgramGuideList == null ) {
            this.uiProgramGuideList = new ArrayList<UiProgramGuideResult>();
        }
        this.totalCount = totalCount;
    }

    /**
     * @return the licenses
     */
    public Collection<UiProgramGuideResult> getUiProgramGuideResultList() {
        return uiProgramGuideList;
    }

    /**
     * @return the totalCount
     */
    public int getTotalCount() {
        return totalCount;
    }

}
