package com.ericsson.cms.epgmgmt.client.model;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UIEndPoint implements IsSerializable {

    private long id;

    private String endpointType;

    private String serverIp;

    private long port;

    private String folder;

    private String fileName;

    private String userName;

    private String password;

    private String fileCheck;

    private boolean isSecure;

    public UIEndPoint() {
        //
    }

    /**
     * Copy from another {@link UIEndPoint}, if the pd is null, IllegalArgumentException will be throw.
     * 
     * @param ep
     */
    public UIEndPoint(UIEndPoint ep) {
        if (ep == null) {
            throw new IllegalArgumentException("parameter 'ep' cannot be null");
        }
        this.id = ep.getId();
        this.userName = ep.getUserName();
        this.password = ep.getPassword();
        this.serverIp = ep.getServerIp();
        this.port = ep.getPort();
        this.isSecure = ep.isSecure();
        this.fileCheck = ep.getFileCheck();
        this.fileName = ep.getFileName();
        this.folder = ep.getFolder();
        this.endpointType = ep.getEndpointType();
    }

    public String getEndpointType() {
        return endpointType;
    }

    public void setEndpointType(String endpointType) {
        this.endpointType = endpointType;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }


    public String getServerIp() {
        return serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public long getPort() {
        return port;
    }

    public void setPort(long port) {
        this.port = port;
    }

    public String getFolder() {
        return folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isSecure() {
        return isSecure;
    }

    public void setSecure(boolean isSecure) {
        this.isSecure = isSecure;
    }

    public String getFileCheck() {
        return fileCheck;
    }

    public void setFileCheck(String fileCheck) {
        this.fileCheck = fileCheck;
    }

}
