package com.ericsson.cms.epgmgmt.client.model;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.view.client.ProvidesKey;

/**
 * Information about a Filter.
 */
public class UIFilterEntity implements Comparable<UIFilterEntity>, IsSerializable {

    public static final ProvidesKey<UIFilterEntity> KEY_PROVIDER = new ProvidesKey<UIFilterEntity>() {
        @Override
        public String getKey(UIFilterEntity item) {
            return item == null ? null : item.getFilterId();
        }
    };

    private static int nextId = 0;

    private int id;
    private String filterId;
    private String filterName;
    private String theSecondaryFilter;
    private UIFilterEntity filterEntity;

    public UIFilterEntity() {

    }

    public UIFilterEntity(String filterId, String filterName) {
        this.filterId = filterId;
        this.filterName = filterName;
    }

    public UIFilterEntity(UIFilterEntity filterEntity) {
        this.id = nextId;
        nextId++;
        setUIFilterEntity(filterEntity);
    }

    @Override
    public int compareTo(UIFilterEntity o) {

        return o == null || o.filterName == null ? -1 : -o.filterName.compareTo(filterName);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof UIFilterEntity) {
            // return id == ((UIFilterEntity) o).id;
            // return filterId.equals(((UIFilterEntity) o).filterId);
            return Integer.parseInt(filterId) == Integer.parseInt(((UIFilterEntity) o).filterId);
        }
        return false;
    }

    /**
     * regex can't used in GWT
     * 
     * @param str
     * @return true is digit
     */
    public boolean isDigit(String str) {
        if (str == null || "".equals(str.trim())) {
            return false;
        }
        boolean isDigit = true;
        for (int i = 0; i < str.length(); i++) {
            if (Character.isDigit(str.charAt(i)) == false) {
                isDigit = false;
                break;
            }
        }
        return isDigit;
    }

    public String getFilterName() {
        return filterName;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public int hashCode() {
        return id;
    }

    public String getFilterId() {
        return filterId;
    }

    public void setFilterId(String filterId) {
        this.filterId = filterId;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public void setUIFilterEntity(UIFilterEntity filterEntity) {
        this.filterEntity = filterEntity;
    }

    public String getTheSecondaryFilter() {
        return theSecondaryFilter;
    }

    public void setTheSecondaryFilter(String theSecondaryFilter) {
        this.theSecondaryFilter = theSecondaryFilter;
    }

}