package com.ericsson.cms.epgmgmt.client.model;

import java.util.Date;

import com.ericsson.cms.epgmgmt.client.model.enumeration.JobStatus;
import com.ericsson.cms.epgmgmt.client.model.enumeration.JobType;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

public class UIJobStatus implements Record<Long>, IsSerializable {

    private long id;

    private long taskId;

    private String taskName;

    private long partnerId;

    private String partnerName;

    private String jobName;

    private JobType jobType;

    private JobStatus jobStatus;

    private String step;

    private int stepProgress;

    private int progress;

    private Date lastExecution;

    private Date nextRunTime;

    private String nodeAddress;

    private String nodeName;

    public UIJobStatus() {
        //
    }

    public UIJobStatus(UIJobStatus jobStatus) {
        if (jobStatus == null) {
            throw new IllegalArgumentException("parameter 'jobStatus' cannot be null");
        }
        this.id = jobStatus.getId();
        this.partnerId = jobStatus.getPartnerId();
        this.taskId = jobStatus.getTaskId();
        this.jobType = jobStatus.getJobType();
        this.jobStatus = jobStatus.getJobStatus();
        this.step = jobStatus.getStep();
        this.stepProgress = jobStatus.getStepProgress();
        this.progress = jobStatus.getProgress();
        this.nextRunTime = jobStatus.getNextRunTime();
        this.lastExecution = jobStatus.getLastExecution();
        this.taskName = jobStatus.getTaskName();
        this.partnerName = jobStatus.getPartnerName();
        this.jobName = jobStatus.getJobName();
        this.nodeName = jobStatus.getNodeName();
        this.nodeAddress = jobStatus.getNodeAddress();
    }

    public JobStatus getJobStatus() {
        return jobStatus;
    }

    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public String getStep() {
        return step;
    }

    public void setStep(String step) {
        this.step = step;
    }

    public int getProgress() {
        return progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getStepProgress() {
        return stepProgress;
    }

    public void setStepProgress(int stepProgress) {
        this.stepProgress = stepProgress;
    }

    public void setNextRunTime(Date t) {
        this.nextRunTime = t;
    }

    public Date getNextRunTime() {
        return nextRunTime;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public Long getKey() {
        return id;
    }

    public long getPartnerId() {
        return partnerId;
    }

    public void setPartnerId(long partnerId) {
        this.partnerId = partnerId;
    }

    public JobType getJobType() {
        return jobType;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public long getTaskId() {
        return taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getPartnerName() {
        return partnerName;
    }

    public void setPartnerName(String partnerName) {
        this.partnerName = partnerName;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public Date getLastExecution() {
        return lastExecution;
    }

    public void setLastExecution(Date lastExecution) {
        this.lastExecution = lastExecution;
    }

    public String getNodeAddress() {
        return nodeAddress;
    }

    public void setNodeAddress(String nodeAddress) {
        this.nodeAddress = nodeAddress;
    }

    public String getNodeName() {
        return nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }
}
