package com.ericsson.cms.epgmgmt.client.model;

import java.util.ArrayList;
import java.util.List;

public class UIOrderedTask extends UITask {

    private int level = 1;

    private int order = 1;

    private List<UIOrderedTask> childTasks;

    public UIOrderedTask() {
        super();
    }

    public UIOrderedTask(UITask task) {
        super(task);
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
        if (childTasks != null) {
            for (UIOrderedTask ot : childTasks) {
                ot.setLevel(level + 1);
            }
        }
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public List<UIOrderedTask> getChildTasks() {
        if (childTasks == null) {
            childTasks = new ArrayList<UIOrderedTask>();
        }
        return childTasks;
    }
}
