package com.ericsson.cms.epgmgmt.client.model;

import com.ericsson.cms.epgmgmt.client.model.enumeration.PartnerType;
import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * 
 * @author epatanu
 *
 */

public class UIPartner implements IsSerializable {

    private long id;
    private String name;
    private String contact;
    private String email;
    private boolean isActive;
    private boolean receiveWarning;
    private PartnerType partnerType;

    public UIPartner(){

    }

    public UIPartner(UIPartner partner) {
        if (partner == null) {
            throw new IllegalArgumentException("parameter 'partner' cannot be null");
        }
        this.name = partner.getName();
        this.id = partner.getId();
        this.email = partner.getEmail();
        this.contact = partner.getContact();
        this.partnerType = partner.getPartnerType();
        this.isActive = partner.isActive();
        this.receiveWarning = partner.isAlert();
    }


    public String getName() {
        return name;
    }

    public String getShortName() {
        if (name == null) {
            return "";
        }

        String hasTip = "...";
        String shortName = name;
        int maxLength = 26; // NOSONAR
        if (name.length() > maxLength + hasTip.length()) {
            shortName = name.substring(0, maxLength - 1) + hasTip;
        }
        return shortName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isActive() {
        return isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isAlert() {
        return receiveWarning;
    }

    public void setAlert(boolean receiveWarning) {
        this.receiveWarning = receiveWarning;
    }

    public boolean isNew() {
        return getId() == 0;
    }

    public void setPartnerType(PartnerType partnerType) {
        this.partnerType = partnerType;
    }

    public PartnerType getPartnerType() {
        return partnerType;
    }

}


