package com.ericsson.cms.epgmgmt.client.model;

import java.util.Date;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UIPluginInfo implements BeanSupport<Long>, IsSerializable {

    private static final String DATE_COLUMN = "createdDate";
    private static final String UPDATE_COLUMN = "updatedDate";
    private static final String INFO_COLUMN = "info";
    private static final String JARNAME_COLUMN = "jarName";
    private static final String FORMAT_COLUMN = "formatName";
    private static final String TYPE_COLUMN = "type";
    private static final String VERSION_COLUMN = "version";
    private static final String ID = "id";

    private long id;

    private String formatName;

    private String jarName;

    private String type;

    private String info;

    private String version;

    private Date createDate;

    private Date updateDate;

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    private boolean isActive;

    private boolean isDeleted;

    public UIPluginInfo() {

    }

    @Override
    public Long getKey() {
        return id;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getFormatName() {
        return formatName;
    }

    public void setFormatName(String format) {
        this.formatName = format;
    }

    public String getJarName() {
        return jarName;
    }

    public void setJarName(String path) {
        this.jarName = path;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public boolean isActive() {
        return isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public Object getProperty(String propertyName) {
        if (ID.equals(propertyName)) {
            return String.valueOf(getId());
        } else if (TYPE_COLUMN.equals(propertyName)) {
            return getType();
        } else if (VERSION_COLUMN.equals(propertyName)) {
            return getVersion();
        } else if (DATE_COLUMN.equals(propertyName)) {
            return getCreateDate().getTime();
        } else if (JARNAME_COLUMN.equals(propertyName)) {
            return getJarName();
        } else if (FORMAT_COLUMN.equals(propertyName)) {
            return getFormatName();
        } else if (INFO_COLUMN.equals(propertyName)) {
            return getInfo();
        } else if (UPDATE_COLUMN.equals(propertyName)) {
            return getUpdateDate().getTime();
        }
        return null;
    }
}
