package com.ericsson.cms.epgmgmt.client.model;

import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UIPluginMgmtResult implements IsSerializable {
    private int result;
    private List<TaskVO> tasks;
    private List<TaskVO> runningTasks;
    public static final int SUCC = 0;
    public static final int COMFIRM = 1;
    public static final int HAS_RUNNING_JOB = 2;
    public static final int OTHER_VERSION_ACTIVE = 3;
    public static final String STATUS_RUNNING = "RUNNING";
    public static final String STATUS_IDEL = "IDEL";

    public UIPluginMgmtResult() {

    }

    public UIPluginMgmtResult(int result) {
        this.result = result;
    }

    public int getResult() {
        return result;
    }

    public List<TaskVO> getTasks() {
        return tasks;
    }

    public void setTasks(List<TaskVO> tasks) {
        this.tasks = tasks;
    }

    public void setSuccess() {
        result = SUCC;
    }

    public boolean isSuccess() {
        return result == SUCC;
    }

    public void setConfirm(){
        result = COMFIRM;
    }

    public boolean needConfirm() {
        return result == COMFIRM;
    }

    public void setHasRunningJob() {
        result = HAS_RUNNING_JOB;
    }

    public boolean hasRunningJob() {
        return result == HAS_RUNNING_JOB;
    }

    public void setOtherVersionActive() {
        result = OTHER_VERSION_ACTIVE;
    }

    public boolean hasOtherVersionActive() {
        return result == OTHER_VERSION_ACTIVE;
    }

    public List<TaskVO> getRunningTasks() {
        return runningTasks;
    }

    public void setRunningTasks(List<TaskVO> runningTasks) {
        this.runningTasks = runningTasks;
    }

    public static class TaskVO implements IsSerializable {
        private String name;
        private boolean isRunning;
        public TaskVO(String name, boolean isRunning){
            this.name = name;
            this.isRunning = isRunning;
        }
        public TaskVO(){
            
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isRunning() {
            return isRunning;
        }

        public void setRunning(boolean isRunning) {
            this.isRunning = isRunning;
        }
    }

}
