package com.ericsson.cms.epgmgmt.client.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UITask implements BeanSupport<Long>, IsSerializable {

    private long id;

    private long partnerId;

    private String partnerName;

    private String partnerType;

    private String formatName;

    private String type;

    private long formatId;

    private UITaskTrigger uiTaskTrigger;

    private boolean isEnabled;

    private boolean isSubscribed;

    private boolean isSendEmail;

    private String name;

    private UIEndPoint endpoint;

    private List<UIPluginProperty> pluginPropertyValues;

    private Map<String, UITaskSetting> taskSettings;

    private UIJobStatus jobStatus;


    public UITask() {
        uiTaskTrigger = new UITaskTrigger();
        taskSettings = new HashMap<String, UITaskSetting>();
    }

    /**
     * Copy from another {@link UITask}, if the pd is null, IllegalArgumentException will be throw.
     * 
     * @param task
     */
    public UITask(UITask task) {
        if (task == null) {
            throw new IllegalArgumentException("parameter 'task' cannot be null");
        }
        this.id = task.getId();
        this.partnerId = task.getPartnerId();
        this.partnerName = task.getPartnerName();
        this.partnerType =  task.getPartnerType();
        this.type = task.getType();
        this.formatId = task.getFormatId();
        this.formatName = task.getFormatName();
        this.uiTaskTrigger = new UITaskTrigger(task.getUiTaskTrigger());
        this.isSendEmail = task.isSendEmail();
        this.isSubscribed = task.isSubscribed();
        this.isEnabled = task.isEnabled();
        this.name = task.getName();
        if (task.getJobStatus() != null) {
            this.jobStatus = new UIJobStatus(task.getJobStatus());
        }
        if (task.getEndpoint() != null) {
            this.endpoint = new UIEndPoint(task.getEndpoint());
        }
        if (task.getPluginPropertyValues() != null) {
            List<UIPluginProperty> l = new ArrayList<UIPluginProperty>();
            for (UIPluginProperty pp : task.getPluginPropertyValues()) {
                l.add(new UIPluginProperty(pp));
            }
            this.pluginPropertyValues = l;
        }
        if (task.getTaskSettings() != null) {
            Map<String, UITaskSetting> map = new HashMap<String, UITaskSetting>(0);
            for (Entry<String, UITaskSetting> e : task.getTaskSettings().entrySet()) {
                map.put(e.getKey(), new UITaskSetting(e.getValue()));
            }
            this.taskSettings = map;
        }
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
        uiTaskTrigger.setId(id);
    }

    public long getPartnerId() {
        return partnerId;
    }

    public void setPartnerId(long partnerId) {
        this.partnerId = partnerId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isEnabled() {
        return isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isSubscribed() {
        return isSubscribed;
    }

    public void setSubscribed(boolean isSubscribed) {
        this.isSubscribed = isSubscribed;
    }

    public boolean isSendEmail() {
        return isSendEmail;
    }

    public void setSendEmail(boolean isSendEmail) {
        this.isSendEmail = isSendEmail;
    }

    @Override
    public Long getKey() {
        return id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public UIEndPoint getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(UIEndPoint endpoint) {
        this.endpoint = endpoint;
    }

    public List<UIPluginProperty> getPluginPropertyValues() {
        return pluginPropertyValues;
    }

    public void setPluginPropertyValues(List<UIPluginProperty> pluginPropertyValues) {
        this.pluginPropertyValues = pluginPropertyValues;
    }

    public long getFormatId() {
        return formatId;
    }

    public void setFormatId(long formatId) {
        this.formatId = formatId;
    }

    public UIJobStatus getJobStatus() {
        return jobStatus;
    }

    public void setJobStatus(UIJobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public String getPartnerName() {
        return partnerName;
    }

    public void setPartnerName(String partnerName) {
        this.partnerName = partnerName;
    }

    public Map<String, UITaskSetting> getTaskSettings() {
        return taskSettings;
    }

    public void setTaskSettings(Map<String, UITaskSetting> taskSettings) {
        this.taskSettings = taskSettings;
    }

    public UITaskTrigger getUiTaskTrigger() {
        return uiTaskTrigger;
    }

    public void setUiTaskTrigger(UITaskTrigger uiTaskTrigger) {
        this.uiTaskTrigger = uiTaskTrigger;
    }

    public String getFormatName() {
        return formatName;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    public String getPartnerType() {
        return partnerType;
    }

    public void setPartnerType(String partnerType) {
        this.partnerType = partnerType;
    }

    @Override
    public Object getProperty(String propertyName) {
        if ("name".equals(propertyName)) {
            return this.getName();
        } else if ("formatName".equals(propertyName)) {
            return this.getFormatName();
        } else if ("triggerType".equals(propertyName)) {
            return this.getUiTaskTrigger().getTriggerType();
        } else if ("status".equals(propertyName)) {
            return this.getJobStatus();
        } else if ("lastExecution".equals(propertyName)) {
            return jobStatus.getLastExecution() == null ? null : jobStatus.getLastExecution().getTime();
        } else if ("nextExecutionTime".equals(propertyName)) {
            return jobStatus.getNextRunTime() == null ? null : jobStatus.getNextRunTime().getTime();
        } else if ("enabled".equals(propertyName)) {
            return this.isEnabled();
        } else if ("partnerName".equals(propertyName)) {
            return this.getPartnerName();
        } else if ("step".equals(propertyName)) {
            return this.getJobStatus().getStep();
        } else if ("type".equals(propertyName)) {
            return this.getType();
        } else if ("progress".equals(propertyName)) {
            return this.getJobStatus().getProgress() + "%";
        }
        return null;
    }

}
