package com.ericsson.cms.epgmgmt.client.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UITaskSetting implements IsSerializable {

    public static final String SUBSCRIBE_TO = "SubscribeTo";
    public static final String PUBLISHER_FILTERS_KEY = "PublishFilters";
    public static final String PROVIDER_KEY = "Provider";
    public static final String STATION_KEY = "Station";
    public static final String HEADEND_KEY = "Headend";
    public static final String PROGRAM_KEY = "Program";
    public static final String KEY_SPLIT_SYMBOL = "-";
    public static final String INCLUDE_VALUE_KEY = "Include";
    public static final String PROVIDER_INCLUDE_KEY = PROVIDER_KEY + KEY_SPLIT_SYMBOL + INCLUDE_VALUE_KEY;
    public static final String EXCLUDE_VALUE_KEY = "Exclude";
    public static final String SCHEDULE_TIME_KEY = "ScheduleTime";
    public static final String SCHEDULE_TIME_DAY_KEY = "ByDay";
    public static final String SCHEDULE_TIME_MONTH_KEY = "ByMonth";
    public static final String SCHEDULE_TIME_WEEK_KEY = "ByWeek";
    private long id;

    private long taskId;

    private String key;

    private Map<String, Object> setting;

    public UITaskSetting() {
        //
    }

    public UITaskSetting(UITaskSetting taskSetting) {
        if (taskSetting == null) {
            throw new IllegalArgumentException("argument [taskSetting] cannot be null");
        }
        this.id = taskSetting.getId();
        this.taskId = taskSetting.getTaskId();
        this.key = taskSetting.getKey();
        if (taskSetting.getSetting() != null) {
            Map<String, Object> map = new HashMap<String, Object>();
            for (Entry<String, Object> e : taskSetting.getSetting().entrySet()) {
                map.put(e.getKey(), e.getValue());
            }
            this.setting = map;
        }
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getTaskId() {
        return taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Map<String, Object> getSetting() {
        return setting;
    }

    public void setSetting(Map<String, Object> setting) {
        this.setting = setting;
    }
}
