package com.ericsson.cms.epgmgmt.client.model;

import com.ericsson.cms.epgmgmt.client.model.enumeration.UiConditionValueTypeEnum;
import com.ericsson.cms.epgmgmt.client.model.enumeration.UiRuleClauseJoinPrefixEnum;
import com.ericsson.cms.epgmgmt.client.model.enumeration.UiRuleCompareOperatorEnum;
import com.google.gwt.user.client.rpc.IsSerializable;

public class UiClause implements IsSerializable, Comparable<UiClause>{

	private long id;
	private UiEntityMapping entityMapping;
	private UiRuleCompareOperatorEnum uiCompareOperator;
	private UiRuleClauseJoinPrefixEnum uiJoinPrefix;
	private UiConditionValueTypeEnum uiConditionValueType;
	private String compareToLiteralValue;
	private UiEntityMapping compareToMappedValue;
	private int layerNumber;
	private int ordering;
	private int groupNumber;
	private boolean negate;
	private boolean ignoreCase;

	/**
	 * @param entityMapping
	 * @param compareOperator
	 * @param joinPrefix
	 * @param conditionValueType
	 * @param compareToLiteralValue
	 * @param compareToMappedValue
	 * @param layerNumber
	 * @param ordering
	 * @param negate
	 */
	public UiClause(UiEntityMapping entityMapping,
			UiRuleCompareOperatorEnum compareOperator,
			UiRuleClauseJoinPrefixEnum joinPrefix,
			UiConditionValueTypeEnum conditionValueType,
			String compareToLiteralValue, UiEntityMapping compareToMappedValue,
			int layerNumber, int ordering, boolean negate, int group, boolean ignoreCase) {
		this.entityMapping = entityMapping;
		this.uiCompareOperator = compareOperator;
		this.uiJoinPrefix = joinPrefix;
		this.uiConditionValueType = conditionValueType;
		this.compareToLiteralValue = compareToLiteralValue;
		this.compareToMappedValue = compareToMappedValue;
		this.layerNumber = layerNumber;
		this.ordering = ordering;
		this.negate = negate;
		this.groupNumber = group;
		this.ignoreCase = ignoreCase;
	}

	public UiClause() {
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public UiEntityMapping getEntityMapping() {
		return entityMapping;
	}

	public void setEntityMapping(UiEntityMapping entityMapping) {
		this.entityMapping = entityMapping;
	}

	public String getCompareToLiteralValue() {
		return compareToLiteralValue;
	}

	public void setCompareToLiteralValue(String compareToLiteralValue) {
		this.compareToLiteralValue = compareToLiteralValue;
	}

	public UiEntityMapping getCompareToMappedValue() {
		return compareToMappedValue;
	}

	public void setCompareToMappedValue(UiEntityMapping compareToMappedValue) {
		this.compareToMappedValue = compareToMappedValue;
	}

	public int getLayerNumber() {
		return layerNumber;
	}

	public void setLayerNumber(int layerNumber) {
		this.layerNumber = layerNumber;
	}

	public int getOrdering() {
		return ordering;
	}

	public void setOrdering(int ordering) {
		this.ordering = ordering;
	}

	public boolean isNegate() {
		return negate;
	}

	public void setNegate(boolean negate) {
		this.negate = negate;
	}

	/**
	 * @return the uiCompareOperator
	 */
	public UiRuleCompareOperatorEnum getUiCompareOperator() {
		return uiCompareOperator;
	}

	/**
	 * @param uiCompareOperator the uiCompareOperator to set
	 */
	public void setUiCompareOperator(UiRuleCompareOperatorEnum uiCompareOperator) {
		this.uiCompareOperator = uiCompareOperator;
	}

	/**
	 * @return the uiJoinPrefix
	 */
	public UiRuleClauseJoinPrefixEnum getUiJoinPrefix() {
		return uiJoinPrefix;
	}

	/**
	 * @param uiJoinPrefix the uiJoinPrefix to set
	 */
	public void setUiJoinPrefix(UiRuleClauseJoinPrefixEnum uiJoinPrefix) {
		this.uiJoinPrefix = uiJoinPrefix;
	}

	/**
	 * @return the uiConditionValueType
	 */
	public UiConditionValueTypeEnum getUiConditionValueType() {
		return uiConditionValueType;
	}

	/**
	 * @param uiConditionValueType the uiConditionValueType to set
	 */
	public void setUiConditionValueType(
			UiConditionValueTypeEnum uiConditionValueType) {
		this.uiConditionValueType = uiConditionValueType;
	}

	
	@Override
	public int compareTo(UiClause arg0) {
		// TODO Auto-generated method stub
		return this.ordering - arg0.ordering;
		
	}

	
	/**
	 * @return the groupNumber
	 */
	public int getGroupNumber() {
		return groupNumber;
	}

	/**
	 * @param groupNumber the groupNumber to set
	 */
	public void setGroupNumber(int groupNumber) {
		this.groupNumber = groupNumber;
	}

	/**
	 * @return the ignoreCase
	 */
	public boolean isIgnoreCase() {
		return ignoreCase;
	}

	/**
	 * @param ignoreCase the ignoreCase to set
	 */
	public void setIgnoreCase(boolean ignoreCase) {
		this.ignoreCase = ignoreCase;
	}
}
