package com.ericsson.cms.epgmgmt.client.model;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Key/Name pair representation for the UI layer.
 * 
 * @author amit.r.seth
 */
public class UiKeyName implements IsSerializable {

	private String key;
	private String name;

	/**
	 * Default constructor
	 */
	public UiKeyName() {
	}

	/**
	 * Constructor
	 * 
	 * @param key
	 *            the key
	 * @param name
	 *            the value/name to be displayed.
	 */
	public UiKeyName(String key, String name) {
		this.key = key;
		this.name = name;
	}

	/**
	 * Get the key
	 * 
	 * @return the key
	 */
	public String getKey() {
		return key;
	}

	/**
	 * Set the key
	 * 
	 * @param key
	 *            the key to set
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * Get the name
	 * 
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Set the name
	 * 
	 * @param name
	 *            the name
	 */
	public void setName(String name) {
		this.name = name;
	}

}
