/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.model;

import java.util.Date;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * @author amit.r.seth
 * 
 */
public class UiNormalizationGroup implements Record<Long>, IsSerializable {

	private Long id;
	private String name;
	private boolean enabled;
	private List<UiNormalizationRule> rules;
	private List<UIProvider> providers;
	
	private List<UIPublisher> publishers;
	private Date updateDate;
	private boolean isGlobalForProviders;
	private boolean isGlobalForPublishers;

	
	public List<UIPublisher> getPublishers() {
		return publishers;
	}

	public void setPublishers(List<UIPublisher> publishers) {
		this.publishers = publishers;
	}
	
	
	public List<UIProvider> getProviders() {
		return providers;
	}

	public void setProviders(List<UIProvider> providers) {
		this.providers = providers;
	}

	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}

	public void setRules(List<UiNormalizationRule> rules) {
		this.rules = rules;
	}

	public UiNormalizationGroup() {
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Boolean getEnabled() {
		return enabled;
	}

	public void setEnabled(Boolean enabled) {
		this.enabled = enabled;
	}

	public List<UiNormalizationRule> getRules() {
		return rules;
	}

	@Override
	public Long getKey() {
		return getId();
	}
	
	/**
	 * @return the updateDate
	 */
	public Date getUpdateDate() {
		return updateDate;
	}

	/**
	 * @param updateDate the updateDate to set
	 */
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	/**
	 * @return the global
	 */
	public boolean isGlobalForProviders() {
		return isGlobalForProviders;
	}

	/**
	 * @param global the global to set
	 */
	public void setIsGlobalForProviders(boolean global) {
		this.isGlobalForProviders = global;
	}
	
	/**
	 * @return the global
	 */
	public boolean isGlobalForPublishers() {
		return isGlobalForPublishers;
	}

	/**
	 * @param global the global to set
	 */
	public void setIsGlobalForPublishers(boolean global) {
		this.isGlobalForPublishers = global;
	}

	public boolean hasProvider(long id) {
		if(getProviders() != null){
			for (UIProvider provider : getProviders()) {
				if (provider.getId() == id) {
					return true;
				}
			}
		}
		
		return false;
	}
	
	public boolean hasPublisher(long id) {
		if(getPublishers() != null){
			for (UIPublisher publisher : getPublishers()) {
				if (publisher.getId() == id) {
					return true;
				}
			}
		}
		
		return false;
	}
}
