package com.ericsson.cms.epgmgmt.client.model;

import java.util.Date;

import com.ericsson.cms.epgmgmt.client.model.enumeration.PGSortPropertyEnum;
import com.ericsson.cms.epgmgmt.client.utils.DateConvert;
import com.google.gwt.user.client.rpc.IsSerializable;

public class UiProgramGuideFilter implements IsSerializable{

    private String providerId;
    private String headendIds;
    private boolean heandendExclude;
    private String stationIds;
    private boolean stationExclude;
    private Date startDate;
    private String time;
    private String timeKey;
    private String duration;
    private PGSortPropertyEnum sortType;
    private boolean isAscending;
    private long startDateInMilliSeconds = 0l;
    private long endDateInMilliSeconds = 0l;

    public UiProgramGuideFilter(){

    }

    public boolean isStationExclude() {
        return stationExclude;
    }

    public void setStationExclude(boolean stationExclude) {
        this.stationExclude = stationExclude;
    }

    public boolean isHeandendExclude() {
        return heandendExclude;
    }

    public void setHeandendExclude(boolean heandendExclude) {
        this.heandendExclude = heandendExclude;
    }

    public String getProviderId() {
        return providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getHeadendIds() {
        return headendIds;
    }

    public void setHeadendIds(String headendIds) {
        this.headendIds = headendIds;
    }

    public String getStationIds() {
        return stationIds;
    }

    public void setStationIds(String stationsIds) {
        this.stationIds = stationsIds;
    }

    /**
     * @return the startDate
     */
    public Date getStartDate() {
        return startDate;
    }
    /**
     * @param startDate the startDate to set
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    /**
     * @return the time
     */
    public String getTime() {
        return time;
    }
    /**
     * @param time the time to set
     */
    public void setTime(String time) {
        this.time = time;
    }


    /**
     * @return the duration
     */
    public String getDuration() {
        return duration;
    }
    /**
     * @param duration the duration to set
     */
    public void setDuration(String duration) {
        this.duration = duration;
    }
    /**
     * @return the sortType
     */
    public PGSortPropertyEnum getSortType() {
        return sortType;
    }
    /**
     * @param sortType the sortType to set
     */
    public void setSortType(PGSortPropertyEnum sortType) {
        this.sortType = sortType;
    }
    /**
     * @return the isAscending
     */
    public boolean isAscending() {
        return isAscending;
    }
    /**
     * @param isAscending the isAscending to set
     */
    public void setAscending(boolean isAscending) {
        this.isAscending = isAscending;
    }

    public void setTimeKey(String timeKey) {
        // TODO Auto-generated method stub
        this.timeKey = timeKey;

    }

    public String getTimeKey() {
        return this.timeKey;
    }
    /**
     * @return the startDateInMilliSeconds
     */
    public long getStartDateInMilliSeconds() {
        return startDateInMilliSeconds;
    }
    /**
     * @param startDateInMilliSeconds the startDateInMilliSeconds to set
     */
    public void setStartDateInMilliSeconds(long startDateInMilliSeconds) {
        this.startDateInMilliSeconds = startDateInMilliSeconds;
    }
    /**
     * @return the endDateInMilliSeconds
     */
    public long getEndDateInMilliSeconds() {
        return endDateInMilliSeconds;
    }
    /**
     * @param endDateInMilliSeconds the endDateInMilliSeconds to set
     */
    public void setEndDateInMilliSeconds(long endDateInMilliSeconds) {
        this.endDateInMilliSeconds = endDateInMilliSeconds;
    }

    public boolean isParamMissing() {
        if (providerId == null) {
            return true;
        } else if (startDate == null) {
            return true;
        } else if (time == null) {
            return true;
        } else if (timeKey == null) {
            return true;
        } else if (duration == null) {
            return true;
        } else if (sortType == null) {
            return true;
        } else if (startDateInMilliSeconds == 0l) {
            return true;
        } else if (endDateInMilliSeconds == 0l) {
            return true;
        }
        return false;
    }

    public Long getEndDateFromStartDate(Long startDateInMilliSeconds){
        return startDateInMilliSeconds+Integer.parseInt(this.getDuration()) * DateConvert.ONE_HOUR;

    }


}
