package com.ericsson.cms.epgmgmt.client.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.ParamType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.TitleFilterOperator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterConditionNode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterRHSFieldNode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.ericsson.cms.epgmgmt.client.model.enumeration.UiRuleClauseJoinPrefixEnum;
import com.ericsson.cms.epgmgmt.client.model.enumeration.UiRuleCompareOperatorEnum;
import com.ericsson.cms.epgmgmt.client.model.predicate.UiPredicate;
import com.google.gwt.user.client.rpc.IsSerializable;

public abstract class UiRule<P extends UiPredicate> implements IsSerializable {

	private long id;
	private String name;
	private List<UiClause> clauses;
	private P predicate;
	private int ordering;

	public UiRule() {

	}
	
	public UiRule(long id) {
		this.id = id;
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public P getPredicate() {
		return predicate;
	}

	public void setPredicate(P predicate) {
		this.predicate = predicate;
	}

	public List<UiClause> getClauses() {
		return clauses;
	}

	public void setClauses(List<UiClause> clauses) {
		this.clauses = clauses;
	}

	public void addClause(UiClause clause) {
		if (this.clauses == null) {
			this.clauses = new ArrayList<UiClause>();
		}
		this.clauses.add(clause);
	}

	/**
	 * @return the ordering
	 */
	public int getOrdering() {
		return ordering;
	}

	/**
	 * @param ordering the ordering to set
	 */
	public void setOrdering(int ordering) {
		this.ordering = ordering;
	}

	public IUITitleFilterNode getUiTitleFilterNode() {
		UITitleFilterListNode uITitleFilterListNode = new UITitleFilterListNode();
		if(clauses != null && clauses.size() > 0) {
			uITitleFilterListNode.setUiRetOperator(clauses.get(0).getUiJoinPrefix()==UiRuleClauseJoinPrefixEnum.Or?TitleFilterOperator.OR:TitleFilterOperator.AND);
			createUiTitleFilterNode(uITitleFilterListNode,clauses,0,0);
		} else {
			return null;
		}
		
		return uITitleFilterListNode;
	}

	private void createUiTitleFilterNode(
			UITitleFilterListNode uITitleFilterListNode,
			List<UiClause> listClauses, int layer, int group) {

	    int lastLayer=0;
	    UiClause clause = new UiClause();
	    UITitleFilterListNode filterList =  new UITitleFilterListNode();
		
		if(listClauses.size()> 0){
			filterList.setUiRetOperator(listClauses.get(0).getUiJoinPrefix()==UiRuleClauseJoinPrefixEnum.Or?TitleFilterOperator.OR:TitleFilterOperator.AND);
		}
		
		layer:
		while(0 < listClauses.size()){
			clause = listClauses.get(0);
			if(clause.getLayerNumber() == layer && clause.getGroupNumber() == group){
				lastLayer = clause.getLayerNumber();
				loadUITitleFilterListNode(filterList,clause);
				listClauses.remove(0);
			}
			else{
				break layer;
			}
		}//Unload the filterList
		//if it is layer 0 then it needs to be added as UITitleFilterValueNode
		if(lastLayer == 0){ 
			for(IUITitleFilterNode node:filterList.getList()){
				UITitleFilterConditionNode valueNode = (UITitleFilterConditionNode) node;
				uITitleFilterListNode.addItem(valueNode);
			}
		}
		// otherwise add the filterList as UITitleFilterListNode
		else if(filterList.getList().size() >= 1){
			uITitleFilterListNode.addItem(filterList);
		}
		
		// going recursive
		if(listClauses.size()>0){
			createUiTitleFilterNode(uITitleFilterListNode,listClauses,clause.getLayerNumber(),clause.getGroupNumber()); 
		}
	}

	private void loadUITitleFilterListNode(UITitleFilterListNode uITitleFilterListNode,UiClause clause){

		UITitleFilterConditionNode valueNode = null;
		switch (clause.getUiConditionValueType()) {
		case mappedField:
			valueNode = new UITitleFilterRHSFieldNode(Long.toString(clause.getEntityMapping().getId()), "EPG",
					UIFieldType.EPG, convertToBaseOperator(clause.getUiCompareOperator()), ParamType.COMPLEX, clause.isIgnoreCase(), clause.isNegate(), clause.getEntityMapping().getDataType().toString(),
					Long.toString(clause.getCompareToMappedValue().getId()), "EPG", UIFieldType.EPG);
			break;
		case value:
		default:
			String value = clause.getCompareToLiteralValue();
			String[] values = {value};
			if (clause.getUiCompareOperator() == UiRuleCompareOperatorEnum.In) {
					values = value.split(",");
			}
			valueNode = new UITitleFilterValueNode(Long.toString(clause.getEntityMapping().getId()), "EPG", UIFieldType.EPG, convertToBaseOperator(clause.getUiCompareOperator()),
					Arrays.asList(values), ParamType.VALUE, clause.isIgnoreCase(), clause.isNegate(), clause.getEntityMapping().getDataType().toString());
			break;
		}
		uITitleFilterListNode.addItem(valueNode);
	}
		
	private static BaseOperator convertToBaseOperator(UiRuleCompareOperatorEnum  uiRuleCompareOperator){
		
		BaseOperator baseOperator;
		
		if(uiRuleCompareOperator != null){
			switch (uiRuleCompareOperator) {
			case Equals:
				baseOperator = BaseOperator.EQUAL; 
				break;
			case GreaterThan:
				baseOperator = BaseOperator.GREATERTHAN; 
				break;
			case GreaterThanEqualsTo:
				baseOperator = BaseOperator.GREATERTHANEQUAL; 
				break;
			case LessThan:
				baseOperator = BaseOperator.LESSTHAN; 
				break;	
			case LessThanEqualsTo:
				baseOperator = BaseOperator.LESSTHANEQUAL; 
				break;
			case Contains:
				baseOperator = BaseOperator.CONTAINS; 
				break;
			case In:
				baseOperator = BaseOperator.IN; 
				break;
			case StartsWith:
				baseOperator = BaseOperator.STARTSWITH; 
				break;
			case EndsWith:
				baseOperator = BaseOperator.ENDSWITH; 
				break;
			case IsEmpty:
				baseOperator = BaseOperator.ISEMPTY; 
				break;
			default:
				baseOperator = null;
				break;
			}
			return baseOperator;
		}
		else{
			return null;
		}
	}
}
