/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.model;

import java.util.Date;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

public class UiValidationGroup implements Record<Long>, IsSerializable {

	private Long id;
	private String name;
	private boolean enabled;
	private List<UiValidationRule> rules;
	private List<UIProvider> providers;
	private Date updateDate;
	private boolean global;

	public List<UIProvider> getProviders() {
		return providers;
	}

	public void setProviders(List<UIProvider> providers) {
		this.providers = providers;
	}

	public void setRules(List<UiValidationRule> rules) {
		this.rules = rules;
	}

	public UiValidationGroup() {
	}

	public Long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Boolean getEnabled() {
		return enabled;
	}

	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}

	public List<UiValidationRule> getRules() {
		return rules;
	}

	@Override
	public Long getKey() {
		return getId();
	}

	/**
	 * @return the updateDate
	 */
	public Date getUpdateDate() {
		return updateDate;
	}

	/**
	 * @param updateDate the updateDate to set
	 */
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	/**
	 * @return the global
	 */
	public boolean isGlobal() {
		return global;
	}

	/**
	 * @param global the global to set
	 */
	public void setGlobal(boolean global) {
		this.global = global;
	}
	
	public boolean hasProvider(long id) {
		for (UIProvider provider : getProviders()) {
			if (provider.getId() == id) {
				return true;
			}
		}
		return false;
	}

}
