package com.ericsson.cms.epgmgmt.client.model.enumeration;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;

public enum LogSourceTypeEnum implements IsSerializable {
    ALL ("", 0),
    PROVIDER ("EPG Provider", 1),
    PUBLISHER ("EPG Receiver", 2);


    private String text;
    private int value;
    private static Map<Integer,String> valueMap;

    LogSourceTypeEnum(){}
    LogSourceTypeEnum(String text, int value) {
        this.text = text;
        this.value = value;
    }

    @Override
    public String toString() {
        return this.text;
    }

    public int getValue(){
        return this.value;
    }

    static{
        valueMap = new HashMap<Integer,String>();
        for (LogSourceTypeEnum sourceType : LogSourceTypeEnum.values()) {
            valueMap.put(Integer.valueOf(sourceType.value), sourceType.text);
        }
    }

    public static String getTextByValue(int value){

        return valueMap.get(Integer.valueOf(value));
    }

    public static String getEnumNameByValue(int value){

        String text;
        switch (value){
        case 0: text ="ALL";
        break;
        case 1: text = "EPG Provider";
        break;
        case 2: text = "EPG Receiver";
        break;
        default: text = "ALL";
        break;

        }
        return text;
    }



    public static LogSourceTypeEnum getEnumByValue(int value){

        LogSourceTypeEnum sourceTypeEnum;
        switch (value){
        case 0: sourceTypeEnum = LogSourceTypeEnum.ALL;
        break;
        case 1: sourceTypeEnum = LogSourceTypeEnum.PROVIDER;
        break;
        case 2: sourceTypeEnum = LogSourceTypeEnum.PUBLISHER;
        break;
        default: sourceTypeEnum = null;
        break;

        }
        return sourceTypeEnum;
    }

}
