package com.ericsson.cms.epgmgmt.client.model.enumeration;

import com.google.gwt.user.client.rpc.IsSerializable;

public enum PartnerType implements IsSerializable {

    Provider("EPG Provider"), Receiver("EPG Receiver");

    private String text;

    PartnerType(String text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return this.text;
    }

    public static PartnerType fromValue(String partnerType) {
        for (PartnerType type : values()) {
            if (type.toString().equals(partnerType)) {
                return type;
            }
        }
        throw new IllegalArgumentException("Unknow enumeration value [" + partnerType + "]");
    }
}
