package com.ericsson.cms.epgmgmt.client.model.enumeration;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;

public enum PluginLogComponentEnum implements IsSerializable{
	ALL ("", 0),
	PLUGIN_FRAMEWORK ("Plug-in Framework", 1),  
	PLUGIN ("Plug-in",2 ), 
	UI ("User Interface", 3), 
	WORKFLOW ("Work Flow", 4), //Camel
	INGEST ("Ingest", 5),
	MERGE ("Merge", 6),
	EXPORT_TO_STG ("Export to Staging", 7),
	EXPORT_TO_XML ("Export to XML", 8),
	VALIDATION_RULES ("Validation Rules", 9),
	NORMALIZATION_RULES ("Normalization Rules", 10),
	SYSTEM ("System", 11);
	
	private String text;
	private int value;
	private static Map<Integer,String> valueMap;
	
	PluginLogComponentEnum(){}
	PluginLogComponentEnum(String text, int value) {
        this.text = text;
        this.value = value;
    }

    @Override
    public String toString() {
        return this.text;
    }
      
    public int getValue(){
    	return this.value;
    }
    
    static{
    	 valueMap = new HashMap<Integer,String>();
    	 for (PluginLogComponentEnum component : PluginLogComponentEnum.values()) {
    			valueMap.put(Integer.valueOf(component.value), component.text);
    	 }
     }
     
    public static String getTextByValue(int value){
    	
    	return valueMap.get(Integer.valueOf(value));
    }
    
    public static String getEnumNameByValue(int value){
    	
    	String text;
    	switch (value){
    	
    	case 0: text = "ALL";
    	break;
    	case 1: text = "PLUGIN_FRAMEWORK";
        break;    	
    	case 2: text = "PLUGIN";
        break;
    	case 3: text = "UI";
        break;
    	case 4: text = "WORKFLOW";
        break; 
    	case 5: text = "INGEST";
        break; 
    	case 6: text = "MERGE";
        break; 
    	case 7: text = "EXPORT_TO_STG";
        break; 
    	case 8: text = "EXPORT_TO_XML";
        break; 
    	case 9: text = "VALIDATION_RULES";
        break; 
    	case 10: text = "NORMALIZATION_RULES";
        break; 
    	case 11: text = "SYSTEM";
        break; 
    	default: text = "Invalid Value: "+ value;
        break;
    	
    	}
    	return text;
    }
    
    
    
    public static PluginLogComponentEnum getEnumByValue(int value){
    	
    	PluginLogComponentEnum componentEnum;
    	switch (value){
    	case 0: componentEnum = PluginLogComponentEnum.ALL;
    	break;
    	case 1: componentEnum = PluginLogComponentEnum.PLUGIN_FRAMEWORK;
    	break;    	
    	case 2: componentEnum = PluginLogComponentEnum.PLUGIN;
    	break;
    	case 3: componentEnum = PluginLogComponentEnum.UI;
    	break;
    	case 4: componentEnum = PluginLogComponentEnum.WORKFLOW;
    	break; 
    	case 5: componentEnum = PluginLogComponentEnum.INGEST;
    	break; 
    	case 6: componentEnum = PluginLogComponentEnum.MERGE;
    	break; 
    	case 7: componentEnum = PluginLogComponentEnum.EXPORT_TO_STG;
    	break; 
    	case 8: componentEnum = PluginLogComponentEnum.EXPORT_TO_XML;
    	break; 
    	case 9: componentEnum = PluginLogComponentEnum.VALIDATION_RULES;
    	break; 
    	case 10: componentEnum = PluginLogComponentEnum.NORMALIZATION_RULES;
    	break; 
    	case 11: componentEnum = PluginLogComponentEnum.SYSTEM;
    	break;    	
    	default: componentEnum = null;
        break;
    	
    	}
    	return componentEnum;
    }
}
