package com.ericsson.cms.epgmgmt.client.model.enumeration;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;

public enum PluginLogSeverityEnum implements IsSerializable{	
	ALL ("", 0),
	INFORMATION ("Information", 1),
	WARNING ("Warning", 2),
	ERROR ("Error", 3),
	CRITICAL ("Critical", 4);
	
	
	private String text;
	private int value;
	private static Map<Integer,String> valueMap;
	
	PluginLogSeverityEnum(){}
	PluginLogSeverityEnum(String text, int value) {
        this.text = text;
        this.value = value;
    }

    @Override
    public String toString() {
        return this.text;
    }
      
    public int getValue(){
    	return this.value;
    }
    
    static{
    	 valueMap = new HashMap<Integer,String>();
    	 for (PluginLogSeverityEnum severity : PluginLogSeverityEnum.values()) {
    			valueMap.put(Integer.valueOf(severity.value), severity.text);
    	 }
     }
     
    public static String getTextByValue(int value){
    	
    	return valueMap.get(Integer.valueOf(value));
    }
    
    public static String getEnumNameByValue(int value){
    	
    	String text;
    	switch (value){
    	case 0: text ="ALL";
    	break;
    	case 1: text = "INFORMATION";
        break;    	
    	case 2: text = "WARNING";
        break;
    	case 3: text = "ERROR";
        break;
    	case 4: text = "CRITICAL";
        break;    	
    	default: text = "Invalid Value: "+ value;
        break;
    	
    	}
    	return text;
    }
    
    
    
    public static PluginLogSeverityEnum getEnumByValue(int value){
    	
    	PluginLogSeverityEnum severityEnum;
    	switch (value){
    	case 0: severityEnum = PluginLogSeverityEnum.ALL;
    	break;
    	case 1: severityEnum = PluginLogSeverityEnum.INFORMATION;
        break;
    	case 2: severityEnum = PluginLogSeverityEnum.WARNING;
        break;
    	case 3: severityEnum = PluginLogSeverityEnum.ERROR;
        break;
    	case 4: severityEnum = PluginLogSeverityEnum.CRITICAL;
        break;    	
    	default: severityEnum = null;
        break;
    	
    	}
    	return severityEnum;
    }
}
