package com.ericsson.cms.epgmgmt.client.model.enumeration;

import com.google.gwt.user.client.rpc.IsSerializable;

public enum ScheduleType implements IsSerializable {

    DAILY("Daily"), WEEKLY("Weekly"), MONTHLY("Monthly");

    private String name;

    ScheduleType(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public static ScheduleType fromValue(String name) {
        for (ScheduleType type : values()) {
            if (type.toString().equalsIgnoreCase(name)) {
                return type;
            }
        }
        throw new IllegalArgumentException("Unknow enumeration value [" + name + "]");
    }
}
