/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.model.enumeration;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * @author eamiset
 *
 */
public enum TimeEnum implements IsSerializable {
	ZERO ("12:00 AM",0),
	ONE ("01:00 AM",1),
	TWO ("02:00 AM",2),
	THREE ("03:00 AM",3),
	FOUR ("04:00 AM",4),
	FIVE ("05:00 AM",5),
	SIX ("06:00 AM",6),
	SEVEN ("07:00 AM",7),
	EIGHT ("08:00 AM",8),
	NINE ("09:00 AM",9),
	TEN ("10:00 AM",10),
	ELEVEN ("11:00 AM",11),
	TWELVE ("12:00 PM",12),
	THIRTEEN ("01:00 PM",13),
	FOURTEEN ("02:00 PM",14),
	FIFTEEN ("03:00 PM",15),
	SIXTEEN ("04:00 PM",16),
	SEVENTEEN ("05:00 PM",17),
	EIGHTEEN ("06:00 PM",18),
	NINETEEN ("07:00 PM",19),
	TWENTY ("08:00 PM",20),
	TWENTYONE ("09:00 PM",21),
	TWENTYTWO ("10:00 PM",22),
	TWENTYTHREE ("11:00 PM",23);

    private String text;
    private int value;
    private static Map<Integer,String> valueMap;
    
    TimeEnum(String text,int value) {
        this.text = text;
        this.value = value;
    }
    
    @Override
    public String toString() {
        return this.text;
    }
    
     public int getValue(){
    	return this.value;
    }
     
    public static String getTextByValue(int value){
    	return valueMap.get(Integer.valueOf(value));
    }
        
    static{
        valueMap = new HashMap<Integer,String>();
        for (TimeEnum time : TimeEnum.values()) {
               valueMap.put(Integer.valueOf(time.value), time.text);
        }
    }
    
 public static String getEnumNameByValue(int value){
    	
    	String text;
    	switch (value){
    	
    	case 0: text = "ZERO";
        break;
    	case 1: text = "ONE";
        break;
    	case 2: text = "TWO";
        break;
    	case 3: text = "THREE";
        break;
    	case 4: text = "FOUR";
        break;
    	case 5: text = "FIVE";
        break;
    	case 6: text = "SIX";
        break;
    	case 7: text = "SEVEN";
        break;
    	case 8: text = "EIGHT";
        break;
    	case 9: text = "NINE";
        break;
    	case 10: text = "TEN";
        break;
    	case 11: text = "ELEVEN";
        break;
    	case 12: text = "TWELVE";
        break;
    	case 13: text = "THIRTEEN";
        break;
    	case 14: text = "FOURTEEN";
        break;
    	case 15: text = "FIFTEEN";
        break;
    	case 16: text = "SIXTEEN";
        break;
    	case 17: text = "SEVENTEEN";
        break;
    	case 18: text = "EIGHTEEN";
        break;
    	case 19: text = "NINETEEN";
        break;
    	case 20: text = "TWENTY";
        break;
    	case 21: text = "TWENTYONE";
        break;
    	case 22: text = "TWENTYTWO";
        break;
    	case 23: text = "TWENTYTHREE";
        break;
    	default: text = "Invalid Value: "+ value;
        break;
    	
    	}
    	return text;
    }
    
    
    
 public static TimeEnum getEnumByValue(int value){
    	
    	TimeEnum timeEnum;
    	switch (value){
    	
    	case 0: timeEnum = TimeEnum.ZERO;
        break;
    	case 1: timeEnum = TimeEnum.ONE;
        break;
    	case 2: timeEnum = TimeEnum.TWO;
        break;
    	case 3: timeEnum = TimeEnum.THREE;
        break;
    	case 4: timeEnum = TimeEnum.FOUR;
        break;
    	case 5: timeEnum = TimeEnum.FIVE;
        break;
    	case 6: timeEnum = TimeEnum.SIX;
        break;
    	case 7: timeEnum = TimeEnum.SEVEN;
        break;
    	case 8: timeEnum = TimeEnum.EIGHT;
        break;
    	case 9: timeEnum = TimeEnum.NINE;
        break;
    	case 10: timeEnum = TimeEnum.TEN;
        break;
    	case 11: timeEnum = TimeEnum.ELEVEN;
        break;
    	case 12: timeEnum = TimeEnum.TWELVE;
        break;
    	case 13: timeEnum = TimeEnum.THIRTEEN;
        break;
    	case 14: timeEnum = TimeEnum.FOURTEEN;
        break;
    	case 15: timeEnum = TimeEnum.FIFTEEN;
        break;
    	case 16: timeEnum = TimeEnum.SIXTEEN;
        break;
    	case 17: timeEnum = TimeEnum.SEVENTEEN;
        break;
    	case 18: timeEnum = TimeEnum.EIGHTEEN;
        break;
    	case 19: timeEnum = TimeEnum.NINETEEN;
        break;
    	case 20: timeEnum = TimeEnum.TWENTY;
        break;
    	case 21: timeEnum = TimeEnum.TWENTYONE;
        break;
    	case 22: timeEnum = TimeEnum.TWENTYTWO;
        break;
    	case 23: timeEnum = TimeEnum.TWENTYTHREE;
        break;
    	default: timeEnum = null;
        break;
    	
    	}
    	return timeEnum;
    }

}
