package com.ericsson.cms.epgmgmt.client.model.enumeration;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;


/**
 * @author orfano
 *
 */
public enum TimeFractionEnum implements IsSerializable {
	ZERO ("12:00 AM",0),
	ZERO_HALF ("12:30 AM",1),
	ONE ("01:00 AM",2),
	ONE_HALF ("01:30 AM",3),
	TWO ("02:00 AM",4),
	TWO_HALF ("02:30 AM",5),
	THREE ("03:00 AM",6),
	THREE_HALF ("03:30 AM",7),
	FOUR ("04:00 AM",8),
	FOUR_HALF ("04:30 AM",9),
	FIVE ("05:00 AM",10),
	FIVE_HALF ("05:30 AM",11),
	SIX ("06:00 AM",12),
	SIX_HALF ("06:30 AM",13),
	SEVEN ("07:00 AM",14),
	SEVEN_HALF ("07:30 AM",15),
	EIGHT ("08:00 AM",16),
	EIGHT_HALF ("08:30 AM",17),
	NINE ("09:00 AM",18),
	NINE_HALF ("09:30 AM",19),
	TEN ("10:00 AM",20),
	TEN_HALF ("10:30 AM",21),
	ELEVEN ("11:00 AM",22),
	ELEVEN_HALF ("11:30 AM",23),
	TWELVE ("12:00 PM",24),
	TWELVE_HALF ("12:30 PM",25),
	THIRTEEN ("01:00 PM",26),
	THIRTEEN_HALF ("01:30 PM",27),
	FOURTEEN ("02:00 PM",28),
	FOURTEEN_HALF ("02:30 PM",29),
	FIFTEEN ("03:00 PM",30),
	FIFTEEN_HALF ("03:30 PM",31),
	SIXTEEN ("04:00 PM",32),
	SIXTEEN_HALF ("04:30 PM",33),
	SEVENTEEN ("05:00 PM",34),
	SEVENTEEN_HALF ("05:30 PM",35),
	EIGHTEEN ("06:00 PM",36),
	EIGHTEEN_HALF ("06:30 PM",37),
	NINETEEN ("07:00 PM",38),
	NINETEEN_HALF ("07:30 PM",39),
	TWENTY ("08:00 PM",40),
	TWENTY_HALF ("08:30 PM",41),
	TWENTYONE ("09:00 PM",42),
	TWENTYONE_HALF ("09:30 PM",43),
	TWENTYTWO ("10:00 PM",44),
	TWENTYTWO_HALF ("10:30 PM",45),
	TWENTYTHREE ("11:00 PM",46),
	TWENTYTHREE_HALF ("11:30 PM",47);

    private String text; 
    private int value;
    private static Map<Integer, String>  valueMap;
    
   
    
    TimeFractionEnum(String text,int value) {
        this.text = text;
        this.value = value;
    }

    
    
    @Override
    public String toString() {
        return this.text;
    }
    
     public int getValue(){
    	return this.value;
    }
    
    
     static{
    	 valueMap = new HashMap<Integer,String>();
    	 for (TimeFractionEnum time : TimeFractionEnum.values()) {
    			valueMap.put(Integer.valueOf(time.value), time.text);
    	 }
     }
     
    public static String getTextByValue(int value){
    	
    	return valueMap.get(Integer.valueOf(value));
    }
    
 public static TimeFractionEnum getEnumByValue(int value){
    	
    	TimeFractionEnum timeEnum;
    	switch (value){
    	
    	case 0: timeEnum = TimeFractionEnum.ZERO;
        break;
    	case 1: timeEnum = TimeFractionEnum.ONE;
        break;
    	case 2: timeEnum = TimeFractionEnum.TWO;
        break;
    	case 3: timeEnum = TimeFractionEnum.THREE;
        break;
    	case 4: timeEnum = TimeFractionEnum.FOUR;
        break;
    	case 5: timeEnum = TimeFractionEnum.FIVE;
        break;
    	case 6: timeEnum = TimeFractionEnum.SIX;
        break;
    	case 7: timeEnum = TimeFractionEnum.SEVEN;
        break;
    	case 8: timeEnum = TimeFractionEnum.EIGHT;
        break;
    	case 9: timeEnum = TimeFractionEnum.NINE;
        break;
    	case 10: timeEnum = TimeFractionEnum.TEN;
        break;
    	case 11: timeEnum = TimeFractionEnum.ELEVEN;
        break;
    	case 12: timeEnum = TimeFractionEnum.TWELVE;
        break;
    	case 13: timeEnum = TimeFractionEnum.THIRTEEN;
        break;
    	case 14: timeEnum = TimeFractionEnum.FOURTEEN;
        break;
    	case 15: timeEnum = TimeFractionEnum.FIFTEEN;
        break;
    	case 16: timeEnum = TimeFractionEnum.SIXTEEN;
        break;
    	case 17: timeEnum = TimeFractionEnum.SEVENTEEN;
        break;
    	case 18: timeEnum = TimeFractionEnum.EIGHTEEN;
        break;
    	case 19: timeEnum = TimeFractionEnum.NINETEEN;
        break;
    	case 20: timeEnum = TimeFractionEnum.TWENTY;
        break;
    	case 21: timeEnum = TimeFractionEnum.TWENTYONE;
        break;
    	case 22: timeEnum = TimeFractionEnum.TWENTYTWO;
        break;
    	case 23: timeEnum = TimeFractionEnum.TWENTYTHREE;
        break;
    	default: timeEnum = null;
        break;
    	
    	}
    	return timeEnum;
    }
}
