package com.ericsson.cms.epgmgmt.client.model.enumeration;

import com.google.gwt.user.client.rpc.IsSerializable;


public enum TriggerType implements IsSerializable {

    FREQUENCY("Frequency"), SCHEDULE("Schedule"), ONDEMAND("On demand");

    private String name;

    TriggerType(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public static TriggerType fromValue(String name) {
        for (TriggerType type : values()) {
            if (type.toString().equalsIgnoreCase(name)) {
                return type;
            }
        }
        throw new IllegalArgumentException("Unknow enumeration value [" + name + "]");
    }
}
