/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.model.enumeration;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * @author kevin
 *
 */
public enum WeekEnum implements IsSerializable {
	MONDAY ("Monday",2),
	TUESDAY ("Tuesday",3),
	WEDNESDAY ("Wednesday",4),
	THURSDAY ("Thursday",5),
	FRIDAY ("Friday",6),
	SATAURDAY ("Saturday",7),
	SUNDAY ("Sunday",1);

    private String text;
    private int value;
    private static Map<Integer,String> valueMap;
    
    WeekEnum(String text,int value) {
        this.text = text;
        this.value = value;
    }

    @Override
    public String toString() {
        return this.text;
    }
    
     public int getValue(){
    	return this.value;
    }
    
     static{
    	 valueMap = new HashMap<Integer,String>();
    	 for (WeekEnum time : WeekEnum.values()) {
    			valueMap.put(Integer.valueOf(time.value), time.text);
    	 }
     }
     
    public static String getTextByValue(int value){
    	
    	return valueMap.get(Integer.valueOf(value));
    }
}
