package com.ericsson.cms.epgmgmt.client.model.util;

import java.util.Date;

import com.ericsson.cms.epgmgmt.client.model.BeanSupport;
import com.ericsson.cms.epgmgmt.client.utils.DateConvert;
import com.ericsson.cms.epgmgmt.client.utils.StringUtils;
import com.ericsson.cms.epgmgmt.client.widget.ButtonView;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public final class TableUtils {
    private TableUtils(){

    }
    public static <R extends BeanSupport<?>> ColumnBase<String, R> createTextColumn(String columnName, String displayName, final String propertyName){
        ColumnBase<String, R> column =  new BeanSupportTextColumn<R>(columnName, displayName, propertyName);
        column.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
        return column;
    }
    public static <R extends BeanSupport<?>> ColumnBase<String, R> createDateColumn(String columnName, String displayName, final String propertyName, String dateFormat){
        ColumnBase<String, R> column = new BeanSupportDateColumn<R>(columnName, displayName, propertyName, dateFormat);
        column.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
        return column;
    }
    public static <R extends BeanSupport<?>> ColumnBase<String, R> createButtonColumn(String columnName, String displayName, String propertyName, RecordClickHandler<R> handler){
        ColumnBase<String, R> column = new ButtonColumn<R>(columnName, displayName,propertyName, handler);
        column.setCellStyle(TableConstants.STYLE_BUTTON);
        return column;
    }
    static class BeanSupportTextColumn<R extends BeanSupport<?>> extends ColumnBase<String, R >{

        private final String propertyName;

        public BeanSupportTextColumn(String name, String displayName, String propertyName) {
            super(name, displayName);
            this.propertyName = propertyName;
        }

        @Override
        public View<String> getView(R record) {
            Object value = record.getProperty(propertyName);
            return new LabelStringView(value==null? "" : value.toString());
        }

    }
    static class BeanSupportDateColumn<R extends BeanSupport<?>> extends ColumnBase<String, R >{

        private final String propertyName;
        private final String dateFormat;

        public BeanSupportDateColumn(String name, String displayName, String propertyName, String dateFormat) {
            super(name, displayName);
            this.propertyName = propertyName;
            this.dateFormat = dateFormat;
        }

        @Override
        public View<String> getView(R record) {
            Object value = record.getProperty(propertyName);
            return new LabelStringView((value == null) || ((Long) value == 0L) ? "" : DateConvert.formatDate(
                    dateFormat, new Date((Long) value)));
        }

    }
    static class ButtonColumn<R extends BeanSupport<?>> extends ColumnBase<String, R >{
        private final RecordClickHandler<R> handler;
        private final String propertyName;

        public ButtonColumn(String name, String displayName, String propertyName, RecordClickHandler<R> handler) {
            super(name, displayName);
            this.propertyName = propertyName;
            this.handler = handler;
        }

        @Override
        public View<String> getView(final R record) {
            String label = this.getDisplayName();
            if(!StringUtils.isEmpty(propertyName) ){
                Object value = record.getProperty(propertyName);
                if(value!=null){
                    label = value.toString();
                }
            }
            ButtonView view = new ButtonView(label, handler.isEnabled(record));
            final ButtonWidget button = (ButtonWidget) view.getWidget();
            button.addClickHandler(new ClickHandler(){
                @Override
                public void onClick(ClickEvent event) {
                    handler.onClick(record, button);
                }
            });
            return view;
        }

    }

    public abstract static class RecordClickHandler<R extends Record<?>> {
        public abstract boolean isEnabled(R r);
        public abstract void onClick(R r , ButtonWidget button);
    }
}
