package com.ericsson.cms.epgmgmt.client.partner;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.utils.MessageAreaUtils;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;


public abstract class AbstractPartnerCreateTab extends AbstractPartnerTab implements IPartnerCreateTab {

    protected final EPGComponentConstants constants = GWT.create(EPGComponentConstants.class);
    protected final EPGComponentMessages constantsMsg = (EPGComponentMessages) GWT.create(EPGComponentMessages.class);
    protected final VerticalContainer mainPanel;
    private final AbstractPartnerTabContainer parentTabContainer;
    private ButtonWidget saveButton;
    private ButtonWidget cancelButton;
    protected HorizontalContainer buttonContainer;
    
    public AbstractPartnerCreateTab(AbstractPartnerTabContainer parentTabContainer) {
        this.parentTabContainer = parentTabContainer;
        mainPanel = new VerticalContainer();
        mainPanel.setSpacing(0);
        mainPanel.setWidth("700px");
    }

    protected void initForm() {
        initButtonContainer();
        initWidget(mainPanel, buttonContainer);
    }
    
    private void initButtonContainer() {
        initSaveButtons();
        initCancelButton();
        buttonContainer = new HorizontalContainer();
        buttonContainer.add(saveButton);
        buttonContainer.add(cancelButton);
    }
    
    private void initSaveButtons() {
        saveButton = new ButtonWidget(constants.buttonLabelSave(), new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                clear();
                List<String> validationMsg = validate();
                if (validationMsg.size() > 0) {
                    MessageAreaUtils.displayErrorMessages("", validationMsg, "", messageArea);
                    return;
                }
                parentTabContainer.validateAndSubmit();
            }
        });

        saveButton.addStyleDependentName("commit-button");
        saveButton.setVisible(true);
    }
    

    abstract public void clear();

    private void initCancelButton() {
        cancelButton = new ButtonWidget(constants.buttonLabelCancel(), new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                parentTabContainer.displayEmpty();
            }
        });
        cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
    }

    @Override
    public void setButtonVisible(boolean visible) {
        saveButton.setVisible(visible);
    }
}
