package com.ericsson.cms.epgmgmt.client.partner;

import com.ericsson.cms.epgmgmt.client.widget.EPGNoIconRoundedDisclosureContainer;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public abstract class AbstractPartnerTab extends Composite implements IPartnerTab, ResizeHandler {
    protected static final String A_HUNDRED_PERCENT = "100%";

    protected MessageArea messageArea;
    private static final String STYLE_DISCLOSURE_CONTAINER = "epg-basicTab-disclosureContainer";

    public MessageArea getMessageArea() {
        return messageArea;
    }

    @Override
    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
    }

    protected HandlerRegistration windowRegistration = null;
    protected final BusyIndicator busyIndicator = new BusyIndicator();
    @Override
    public void updateScrollPanelSize(){
        
    }
    @Override
    public void onResize(ResizeEvent event){
        updateScrollPanelSize();
    }
    @Override
    protected void onLoad() {
        super.onLoad();
        windowRegistration = Window.addResizeHandler(this);
    };

    @Override
    protected void onUnload() {
        windowRegistration.removeHandler();
        windowRegistration = null;

        if (busyIndicator != null) {
            busyIndicator.hide();
        }
        super.onUnload();
    }

    private ScrollContainer scrollContainer ;
    protected void initWidget(Widget widget, Widget buttons) {
        
        scrollContainer = new ScrollContainer(widget);
        
        VerticalContainer vertiContainer = new VerticalContainer();
        vertiContainer.add(scrollContainer);
        vertiContainer.add(buttons);
        vertiContainer.setWidth(A_HUNDRED_PERCENT);

        EPGNoIconRoundedDisclosureContainer mainDisclosure = new EPGNoIconRoundedDisclosureContainer(new LabelWidget(getDisplayName()), true);
        mainDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        mainDisclosure.setContent(vertiContainer);
        mainDisclosure.setWidth("1100px");
        
        
        initWidget(mainDisclosure);
    }
    
    public void setHeight(int height) {
        int tabHeight = (height - 83); //NOSOAR
        if (scrollContainer != null && tabHeight > 0) {
            scrollContainer.setHeight(tabHeight + "px");
        }
    }
}
