package com.ericsson.cms.epgmgmt.client.partner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.ExecutionLogFilter;
import com.ericsson.cms.epgmgmt.client.model.ExecutionLogResult;
import com.ericsson.cms.epgmgmt.client.model.UIExecutionLog;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.ericsson.cms.epgmgmt.client.model.util.TableUtils;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGExecutionLogService;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGExecutionLogServiceAsync;
import com.ericsson.cms.epgmgmt.client.utils.StringUtils;
import com.ericsson.cms.epgmgmt.client.widget.CustomizableHorizontalView;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public class ExecutionLogDataProvider implements DataProvider<Long, UIExecutionLog> {

    //Filter
    private ExecutionLogFilter filter;

    // columns for this table
    private final List<Column<?, UIExecutionLog>> columns;
    private final ColumnBase<String, UIExecutionLog> dateColumn;

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);

    private PageFeature parentPageFeature;
    private SortFeatureImpl<Long, UIExecutionLog> parentSortFeature;

    private final IEPGExecutionLogServiceAsync executionLogService = GWT.create(IEPGExecutionLogService.class);

    private final BusyIndicator busyIndicator = new BusyIndicator();
    private Map<Long, UITask> tasks;

    private static final String TASK_NAME="taskName";
    private static final String START_DATE_COLUMN = "startDate";
    private static final String END_DATE_COLUMN = "endDate";
    private static final String STATUS_COLUMN = "status";
    private static final String EXECUTION_TIME="executionTime";
    private static final String RUN_ON_COLUMN = "runOn";
    private static final String DETAIL_COLUMN = "Detail";
    private static final String STYLE_LABEL_CENTER = "taskPanel-label-center";

    public ExecutionLogDataProvider(final ExectionLogType type) {
        columns = new ArrayList<Column<?, UIExecutionLog>>();
        if (ExectionLogType.Partner.equals(type)) {
            addTaskNameColumn();
        }
        dateColumn = TableUtils.<UIExecutionLog> createDateColumn(START_DATE_COLUMN, constants.jobStartDateLabel(),
                START_DATE_COLUMN, constants.activityLogTimeFormat());
        columns.add(dateColumn);
        columns.add(TableUtils.<UIExecutionLog> createDateColumn(END_DATE_COLUMN, constants.jobEndDateLabel(),
                END_DATE_COLUMN, constants.activityLogTimeFormat()));
        columns.add(new ExecutionStatusColumn(STATUS_COLUMN, constants.jobStatusLabel()));
        columns.add(TableUtils.<UIExecutionLog> createTextColumn(EXECUTION_TIME, constants.jobExecutionTimeLable(),
                EXECUTION_TIME));
        columns.add(TableUtils.<UIExecutionLog> createTextColumn(RUN_ON_COLUMN, constants.jobExecutionRunOnLabel(),
                RUN_ON_COLUMN));
        columns.add(createDetailColumn());
    }

    private ColumnBase<String, UIExecutionLog> createDetailColumn() {
        ColumnBase<String, UIExecutionLog> c = new ColumnBase<String, UIExecutionLog>(DETAIL_COLUMN,
                constants.jobExecutionDetailLable()) {

            @Override
            public View<String> getView(final UIExecutionLog record) {
                final CustomizableHorizontalView v = new CustomizableHorizontalView();
                ButtonWidget button = new ButtonWidget(constants.jobExecutionDetailLable());
                button.addClickHandler(new ClickHandler() {

                    @Override
                    public void onClick(ClickEvent event) {
                        new ExecutionStepPopup(record).show();
                    }
                });
                v.getContainer().add(button);
                if (StringUtils.isNotEmpty(record.getComments())) {
                    ImageWidget img = new ImageWidget("cms_epgmgmt_ui/images/warning.png");
                    img.setTitle(record.getComments());
                    v.getContainer().add(img);
                }
                return v;
            }
        };
        c.setCellStyle(STYLE_LABEL_CENTER);
        return c;
    }

    private void addTaskNameColumn() {
        columns.add(new ColumnBase<String, UIExecutionLog>(TASK_NAME, constants.jobTaskNameLabel()){
            @Override
            public View<String> getView(UIExecutionLog record) {
                String value = "";
                UITask task = tasks.get(record.getTaskId());
                if (task != null) {
                    value = task.getName();
                }
                return new LabelStringView(value);
            }
        });
    }

    public ColumnBase<String, UIExecutionLog> getDefaultSortColumn() {
        return dateColumn;
    }

    public List<Column<?, UIExecutionLog>> getSortColumns() {
        return columns;
    }

    @Override
    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess( null );
    }

    @Override
    public List<Column<?, UIExecutionLog>> getColumns() {
        return columns;
    }

    @Override
    public void getRecord(Long key, final AsyncCallback<UIExecutionLog> callback) {
    }

    @Override
    public void getRecords(final AsyncCallback<List<UIExecutionLog>> callback) {

        filter.setPageInfo(getParentPageFeature().getPageNumber(),
                getParentPageFeature().getPageSize(),
                getParentSortFeature().getSortColumnName(),
                getParentSortFeature().isAscending());

        busyIndicator.center();
        executionLogService.findExecutionLog(filter, new NeptuneAsyncCallback<ExecutionLogResult>() {

            @Override
            public void onNeptuneFailure(Throwable caught) {
                getParentPageFeature().setRecordCount(-1);
                callback.onFailure(caught);
                busyIndicator.hide();
            }

            @Override
            public void onNeptuneSuccess(ExecutionLogResult result ) {
                getParentPageFeature().setRecordCount(result.getTotalCount());
                List<UIExecutionLog> uiJobRecords = new ArrayList<UIExecutionLog>(result.getLogs());
                callback.onSuccess(uiJobRecords);
                busyIndicator.hide();
            }

        } );
    }


    @Override
    public boolean isRecordCountEnabled() {
        return true;
    }

    @Override
    public boolean isCheckboxEnabled() {
        return false;
    }

    public PageFeature getParentPageFeature() {
        return parentPageFeature;
    }

    public void setParentPageFeature(PageFeature parentPageFeature) {
        this.parentPageFeature = parentPageFeature;
    }

    public SortFeatureImpl<Long, UIExecutionLog> getParentSortFeature() {
        return parentSortFeature;
    }

    public void setParentSortFeature(
            SortFeatureImpl<Long, UIExecutionLog> parentSortFeature) {
        this.parentSortFeature = parentSortFeature;
    }

    public void setFilter(ExecutionLogFilter filter){
        this.filter = filter;
    }

    public ExecutionLogFilter getFilter() {
        return filter;
    }

    public void setTasks(Map<Long, UITask> taskMap) {
        this.tasks = taskMap;
    }
}
