package com.ericsson.cms.epgmgmt.client.partner;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.ExecutionLogFilter;
import com.ericsson.cms.epgmgmt.client.model.UIExecutionLog;
import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.ericsson.cms.epgmgmt.client.model.enumeration.JobType;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGTaskService;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGTaskServiceAsync;
import com.ericsson.cms.epgmgmt.client.utils.DateConvert;
import com.ericsson.cms.epgmgmt.client.utils.DateUtils;
import com.ericsson.cms.epgmgmt.client.utils.DefaultAsyncCallback;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public final class ExecutionLogTab extends AbstractPartnerTab{
    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);
    private VerticalContainer mainPanel;
    private Composite parentTabContainer;
    private TypedDateBoxWidget startDateDropBox;
    private TypedDateBoxWidget endDateDropBox;
    private UIPartner uiPartner;
    private final HorizontalContainer partnerPanel = new HorizontalContainer();
    private static IEPGTaskServiceAsync  taskService = GWT.create(IEPGTaskService.class);
    private static final int PAGE_SIZE = 10; // NOSONAR
    private static final String imageUrl = "cms_epgmgmt_ui/images/"; // NOSONAR

    // table related
    private ExecutionLogDataProvider dataProvider;

    private Table<Long, UIExecutionLog> table;
    private final String partnerType;
    private TypedListBoxWidget<Long> taskListBox;
    private final ExectionLogType executionLogType;

    private ExecutionLogTab(JobType partnerType, ExectionLogType executionLogType) {
        this.partnerType = partnerType.toString();
        this.executionLogType = executionLogType;
        init();
    }

    public static ExecutionLogTab createForPartner(JobType jobType) {
        return new ExecutionLogTab(jobType, ExectionLogType.Partner);
    }

    public static ExecutionLogTab createForTask(JobType jobType) {
        return new ExecutionLogTab(jobType, ExectionLogType.Task);
    }

    private void init() {
        mainPanel = new VerticalContainer();
        mainPanel.setSpacing(10);  // NOSONAR
        if (executionLogType == ExectionLogType.Partner) {
            mainPanel.setWidth("100%");
        }

        startDateDropBox = this.createDateBox(DateUtils.getDateStrBeforeToday(constants.activityLogDateFormat(), 10));//NOSONAR
        endDateDropBox = this.createDateBox(DateUtils.getDateStrForToday(constants.activityLogDateFormat()));
        taskListBox = this.createTaskListBox();

        fillPartnerPanel();
        initDataTable();

        initWidget(mainPanel);
    }

    private void initDataTable() {
        dataProvider = new ExecutionLogDataProvider(executionLogType);

        table = new Table<Long, UIExecutionLog>(dataProvider);

        PageFeature pageFeature = new PageFeatureImpl();
        pageFeature.setPageSize(PAGE_SIZE);
        dataProvider.setParentPageFeature(pageFeature);

        SortFeatureImpl<Long, UIExecutionLog> sortFeature = new SortFeatureImpl<Long, UIExecutionLog>(
                dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING);
        for (Column<?, UIExecutionLog> col : dataProvider.getSortColumns()) {
            sortFeature.addSortableColumn(col);
        }
        dataProvider.setParentSortFeature(sortFeature);

        table.addSortFeature(sortFeature);
        table.addPageFeature(pageFeature);

        table.initialize(new DefaultAsyncCallback<Void>(null));

        table.setWidth("100%");
        mainPanel.add(table);
    }

    private void fillPartnerPanel() {
        partnerPanel.setSpacing(10);
        partnerPanel.add(new LabelWidget(constants.activityLogStartDateLabel()));
        partnerPanel.add(startDateDropBox);
        partnerPanel.add(new LabelWidget(constants.activityLogEndDateLabel()));
        partnerPanel.add(endDateDropBox);
        if(ExectionLogType.Partner.equals(executionLogType)){
            partnerPanel.add(new LabelWidget(constants.jobTaskLable()));
            partnerPanel.add(taskListBox);
        }
        ButtonWidget searchButton = new ButtonWidget();
        searchButton.setText(constants.buttonLabelSearch());
        searchButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);
        searchButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                triggerSearch();
            }
        });
        partnerPanel.add(searchButton);
        mainPanel.add(partnerPanel);
    }

    public Composite getParentTabContainer() {
        return parentTabContainer;
    }

    @Override
    public String getDisplayName() {
        return constants.logDisplayMsgTab();
    }

    @Override
    public String getName() {
        return constants.executionLogLabel();
    }

    @Override
    public void setSelected(boolean selected) {
        if (!selected) {
            return;
        }
        updateScrollPanelSize();
    }

    private boolean isValidate() {
        Date stDate = startDateDropBox.getDatePicker().getValue();
        Date edDate = endDateDropBox.getDatePicker().getValue();

        boolean valid = true;

        if ((stDate != null) && (edDate != null) && !(edDate.after(stDate) || edDate.equals(stDate))) {
            valid = false;
            startDateDropBox.showValidationError(constants.activityLogDateValidation());
            if(messageArea!=null){
                messageArea.setErrorMessage(constants.activityLogDateValidation());
            }
        } else {
            startDateDropBox.clearValidationError();
        }

        return valid;
    }

    public void refreshData(UIPartner uiPartner) {
        this.uiPartner = uiPartner;
        dataProvider.setFilter(getFilter());
        fillTaskList(this.uiPartner);
    }

    public void refreshData(UITask uiTask) {
        if((uiTask==null) || (uiTask.getId()<0)) {
            return;
        }
        ExecutionLogFilter filter = getFilter();
        filter.setTaskId(uiTask.getId());
        filter.setPartnerId(uiTask.getPartnerId());
        dataProvider.setFilter(filter);
        triggerSearch();
    }

    private void fillTaskList(UIPartner uiPartner) {
        this.uiPartner = uiPartner;
        taskService.getTasks(uiPartner.getId().longValue(), new DefaultAsyncCallback<List<UITask>>(messageArea){
            @Override
            public void onNeptuneSuccess(List<UITask> result) {
                HashMap<Long, UITask> taskMap = new HashMap<Long ,UITask>();
                taskListBox.clear();
                taskListBox.addItem("",-1L);
                for(UITask task: result){
                    taskListBox.addItem(task.getName(), task.getId());
                    taskMap.put(task.getId(), task);
                }
                dataProvider.setTasks(taskMap);
                dataProvider.setFilter(getFilter());
                triggerSearch();
            }
        });
    }

    public boolean validatePartner(UIPartner partner) {
        return (partner != null) && (partner.getId() > 0);
    }

    public UIPartner getUiPartner() {
        return uiPartner;
    }

    private ExecutionLogFilter getFilter() {
        if (!isValidate()) {
            return null;
        }
        ExecutionLogFilter filter = new ExecutionLogFilter();
        if(uiPartner!=null){
            filter.setPartnerId(getUiPartner().getId());
            filter.setTaskId(taskListBox.getSelectedItem());
        }
        filter.setPartnerType(partnerType);

        filter.setStartDate(DateConvert.parseDate(constants.activityLogDateFormat(), startDateDropBox.getTextValue())
                .getTime());
        filter.setEndDate(DateConvert.parseDate(constants.activityLogDateFormat(), endDateDropBox.getTextValue())
                .getTime());

        return filter;
    }

    private void triggerSearch() {
        bindSearchCondition();
        this.table.refresh();
    }

    private void bindSearchCondition() {
        ExecutionLogFilter filter = dataProvider.getFilter();
        filter.setStartDate(startDateDropBox.getDatePicker().getValue().getTime());
        filter.setEndDate(endDateDropBox.getDatePicker().getValue().getTime());
        if(ExectionLogType.Partner.equals(executionLogType)){
            filter.setTaskId(taskListBox.getSelectedItem());
        }

    }

    public void setParentTabContainer(Composite parentTabContainer) {
        this.parentTabContainer = parentTabContainer;
    }

    @Override
    public void reload() {

    }

    private TypedDateBoxWidget createDateBox(String defaultValue) {
        TypedDateBoxWidget dateDropBox = new TypedDateBoxWidget(new DateConverter(constants.activityLogDateFormat(),
                constants.activityLogDateFormat()));
        dateDropBox.setSize("100px", "15px");
        dateDropBox.setTextValue(defaultValue);
        return dateDropBox;
    }

    private TypedListBoxWidget<Long> createTaskListBox() {
        TypedListBoxWidget<Long> taskBox = new TypedListBoxWidget<Long>(new IntegerConverter());
        taskBox.setSize("100px", "18px");
        return taskBox;
    }

    @Override
    public List<String> validate() {
        throw new UnsupportedOperationException();
    }

    public void setUiPartner(UIPartner uiPartner) {
        this.uiPartner = uiPartner;
    }

}
