package com.ericsson.cms.epgmgmt.client.partner;

import com.ericsson.cms.epgmgmt.client.model.BeanSupport;
import com.ericsson.cms.epgmgmt.client.model.enumeration.JobStatus;
import com.ericsson.cms.epgmgmt.client.widget.ImageLabelView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;

public final class ExecutionStatusColumn<T extends BeanSupport<?>> extends ColumnBase<String, T> {
    ExecutionStatusColumn(String name, String displayName) {
        super(name, displayName);
    }

    @Override
    public View<String> getView(T executionog) {
        String label = "";
        String imageUrl = "";
        String status = (String) executionog.getProperty("status"); 
        if(status.equals("Running")) {
            label = "Running";
            imageUrl = "cms_epgmgmt_ui/images/running_inprogress.png";
        }else if(status.equals("Completed")){
            imageUrl = "cms_epgmgmt_ui/images/running_completed.png";
            label = JobStatus.COMPLETED.toString();
        }else if(status.equals("Failed")){
            imageUrl = "cms_epgmgmt_ui/images/running_failed.png";
            label = JobStatus.FAILDED.toString();
        }else if(status.equals("Canceled")){
            imageUrl = "cms_epgmgmt_ui/images/running_cancelled.png";
            label = JobStatus.CANCELD.toString();
        }
        return new ImageLabelView("",label, imageUrl);
    }
}